/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cert.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.KeyStore;
import java.util.ArrayList;
import org.opendaylight.aaa.cert.api.IAaaCertMdsalProvider;
import org.opendaylight.aaa.cert.impl.ODLKeyTool;
import org.opendaylight.aaa.cert.utils.KeyStoresDataUtils;
import org.opendaylight.aaa.cert.utils.MdsalUtils;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.KeyStores;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.KeyStoresBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.cipher.suite.CipherSuites;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.cipher.suite.CipherSuitesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.OdlKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.TrustKeystore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AaaCertMdsalProvider
implements IAaaCertMdsalProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AaaCertMdsalProvider.class);
    private final DataBroker dataBroker;
    private final KeyStoresDataUtils keyStoresData;
    private final ODLKeyTool odlKeyTool;

    public AaaCertMdsalProvider(DataBroker dataBroker, AAAEncryptionService encryptionSrv) {
        this.dataBroker = dataBroker;
        this.keyStoresData = new KeyStoresDataUtils(encryptionSrv);
        this.odlKeyTool = new ODLKeyTool();
        LOG.info("AaaCertMdsalProvider Initialized");
    }

    @Override
    public boolean addODLStoreSignedCertificate(String bundleName, String alias, String certificate) {
        SslData sslData = this.keyStoresData.getSslData(this.dataBroker, bundleName);
        if (sslData != null && sslData.getOdlKeystore() != null) {
            KeyStore keystore = this.odlKeyTool.loadKeyStore(sslData.getOdlKeystore().getKeystoreFile(), sslData.getOdlKeystore().getStorePassword());
            if ((keystore = this.odlKeyTool.addCertificate(keystore, certificate, alias, false)) != null) {
                OdlKeystore odlKeystore = KeyStoresDataUtils.updateOdlKeystore(sslData.getOdlKeystore(), this.odlKeyTool.convertKeystoreToBytes(keystore, sslData.getOdlKeystore().getStorePassword()));
                return this.keyStoresData.updateSslDataOdlKeystore(this.dataBroker, sslData, odlKeystore);
            }
        }
        return false;
    }

    @Override
    public SslData addSslDataKeystores(String bundleName, String odlKeystoreName, String odlKeystorePwd, String odlKeystoreAlias, String odlKeystoreDname, String odlKeystoreKeyAlg, String odlKeystoreSignAlg, int odlKeystoreKeysize, int odlKeystoreValidity, String trustKeystoreName, String trustKeystorePwd, String[] cipherSuites, String tlsProtocols) {
        OdlKeystore odlKeystore = this.keyStoresData.createOdlKeystore(odlKeystoreName, odlKeystoreAlias, odlKeystorePwd, odlKeystoreDname, odlKeystoreSignAlg, odlKeystoreKeyAlg, odlKeystoreValidity, odlKeystoreKeysize, this.odlKeyTool);
        TrustKeystore trustKeystore = this.keyStoresData.createTrustKeystore(trustKeystoreName, trustKeystorePwd, this.odlKeyTool);
        ArrayList<CipherSuites> cipherSuitesList = new ArrayList<CipherSuites>();
        if (cipherSuites != null) {
            for (String suite : cipherSuites) {
                CipherSuites cipherSuite = new CipherSuitesBuilder().setSuiteName(suite).build();
                cipherSuitesList.add(cipherSuite);
            }
        }
        return this.keyStoresData.addSslData(this.dataBroker, bundleName, odlKeystore, trustKeystore, cipherSuitesList, tlsProtocols);
    }

    @Override
    public SslData addSslDataKeystores(String bundleName, String odlKeystoreName, String odlKeystorePwd, String odlKeystoreAlias, String odlKeystoreDname, String trustKeystoreName, String trustKeystorePwd, String[] cipherSuites, String tlsProtocols) {
        return this.addSslDataKeystores(bundleName, odlKeystoreName, odlKeystorePwd, odlKeystoreAlias, odlKeystoreDname, "RSA", "SHA1WithRSAEncryption", 2048, 365, trustKeystoreName, trustKeystorePwd, cipherSuites, tlsProtocols);
    }

    @Override
    public boolean addTrustNodeCertificate(String bundleName, String alias, String certificate) {
        SslData sslData = this.keyStoresData.getSslData(this.dataBroker, bundleName);
        if (sslData != null && sslData.getTrustKeystore() != null) {
            KeyStore keystore = this.odlKeyTool.loadKeyStore(sslData.getTrustKeystore().getKeystoreFile(), sslData.getTrustKeystore().getStorePassword());
            if ((keystore = this.odlKeyTool.addCertificate(keystore, certificate, alias, true)) != null) {
                TrustKeystore trustKeystore = this.keyStoresData.updateTrustKeystore(sslData.getTrustKeystore(), this.odlKeyTool.convertKeystoreToBytes(keystore, sslData.getTrustKeystore().getStorePassword()));
                return this.keyStoresData.updateSslDataTrustKeystore(this.dataBroker, sslData, trustKeystore);
            }
        }
        return false;
    }

    @Override
    public void exportSslDataKeystores(String bundleName) {
        SslData sslData = this.keyStoresData.getSslData(this.dataBroker, bundleName);
        if (sslData != null) {
            KeyStore keystore = this.odlKeyTool.loadKeyStore(sslData.getTrustKeystore().getKeystoreFile(), sslData.getTrustKeystore().getStorePassword());
            this.odlKeyTool.exportKeystore(keystore, sslData.getTrustKeystore().getStorePassword(), bundleName + "_trustKeystore");
            keystore = this.odlKeyTool.loadKeyStore(sslData.getOdlKeystore().getKeystoreFile(), sslData.getOdlKeystore().getStorePassword());
            this.odlKeyTool.exportKeystore(keystore, sslData.getOdlKeystore().getStorePassword(), bundleName + "_odlKeystore");
        }
    }

    @Override
    public String genODLKeyStoreCertificateReq(String bundleName, boolean withTag) {
        SslData sslData = this.keyStoresData.getSslData(this.dataBroker, bundleName);
        if (sslData != null) {
            OdlKeystore odlKeyStore = sslData.getOdlKeystore();
            KeyStore keystore = this.odlKeyTool.loadKeyStore(odlKeyStore.getKeystoreFile(), sslData.getOdlKeystore().getStorePassword());
            return this.odlKeyTool.generateCertificateReq(keystore, odlKeyStore.getStorePassword(), odlKeyStore.getAlias(), odlKeyStore.getSignAlg(), withTag);
        }
        return null;
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public String[] getCipherSuites(String bundleName) {
        SslData sslData = this.keyStoresData.getSslData(this.dataBroker, bundleName);
        if (sslData != null && sslData.getCipherSuites() != null && !sslData.getCipherSuites().isEmpty()) {
            ArrayList suites = new ArrayList();
            sslData.getCipherSuites().stream().forEach(cs -> {
                if (!cs.getSuiteName().isEmpty()) {
                    suites.add(cs.getSuiteName());
                }
            });
            return suites.toArray(new String[suites.size()]);
        }
        return null;
    }

    @Override
    public KeyStore getODLKeyStore(String bundleName) {
        SslData sslData = this.keyStoresData.getSslData(this.dataBroker, bundleName);
        if (sslData != null && sslData.getOdlKeystore() != null) {
            return this.odlKeyTool.loadKeyStore(sslData.getOdlKeystore().getKeystoreFile(), sslData.getOdlKeystore().getStorePassword());
        }
        return null;
    }

    @Override
    public String getODLStoreCertificate(String bundleName, boolean withTag) {
        SslData sslData = this.keyStoresData.getSslData(this.dataBroker, bundleName);
        if (sslData != null) {
            OdlKeystore odlKeyStore = sslData.getOdlKeystore();
            KeyStore keystore = this.odlKeyTool.loadKeyStore(odlKeyStore.getKeystoreFile(), odlKeyStore.getStorePassword());
            return this.odlKeyTool.getCertificate(keystore, odlKeyStore.getAlias(), withTag);
        }
        return null;
    }

    @Override
    public SslData getSslData(String bundleName) {
        return this.keyStoresData.getSslData(this.dataBroker, bundleName);
    }

    @Override
    public KeyStore getTrustKeyStore(String bundleName) {
        SslData sslData = this.keyStoresData.getSslData(this.dataBroker, bundleName);
        if (sslData != null && sslData.getTrustKeystore() != null) {
            return this.odlKeyTool.loadKeyStore(sslData.getTrustKeystore().getKeystoreFile(), sslData.getTrustKeystore().getStorePassword());
        }
        return null;
    }

    @Override
    public String getTrustStoreCertificate(String bundleName, String alias, boolean withTag) {
        SslData sslData = this.keyStoresData.getSslData(this.dataBroker, bundleName);
        if (sslData != null) {
            TrustKeystore trustKeyStore = sslData.getTrustKeystore();
            KeyStore keystore = this.odlKeyTool.loadKeyStore(trustKeyStore.getKeystoreFile(), trustKeyStore.getStorePassword());
            return this.odlKeyTool.getCertificate(keystore, alias, withTag);
        }
        return null;
    }

    @Override
    public SslData importSslDataKeystores(String bundleName, String odlKeystoreName, String odlKeystorePwd, String odlKeystoreAlias, KeyStore odlKeyStore, String trustKeystoreName, String trustKeystorePwd, KeyStore trustKeyStore, String[] cipherSuites, String tlsProtocols) {
        OdlKeystore odlKeystore = this.keyStoresData.createOdlKeystore(odlKeystoreName, odlKeystoreAlias, odlKeystorePwd, this.odlKeyTool.convertKeystoreToBytes(odlKeyStore, odlKeystorePwd));
        TrustKeystore trustKeystore = this.keyStoresData.createTrustKeystore(trustKeystoreName, trustKeystorePwd, this.odlKeyTool.convertKeystoreToBytes(trustKeyStore, trustKeystorePwd));
        ArrayList<CipherSuites> cipherSuitesList = new ArrayList<CipherSuites>();
        for (String suit : cipherSuites) {
            CipherSuites cipherSuite = new CipherSuitesBuilder().setSuiteName(suit).build();
            cipherSuitesList.add(cipherSuite);
        }
        return this.keyStoresData.addSslData(this.dataBroker, bundleName, odlKeystore, trustKeystore, cipherSuitesList, tlsProtocols);
    }

    @Override
    public boolean removeSslData(String bundleName) {
        return this.keyStoresData.removeSslData(this.dataBroker, bundleName);
    }

    @Override
    public SslData updateSslData(SslData sslData) {
        if (this.keyStoresData.updateSslData(this.dataBroker, sslData)) {
            return sslData;
        }
        return null;
    }

    @Override
    public void initializeKeystoreDataTree() {
        if (MdsalUtils.read(this.dataBroker, LogicalDatastoreType.CONFIGURATION, KeyStoresDataUtils.getKeystoresIid()) == null) {
            KeyStores keyStoreData = new KeyStoresBuilder().setId("KeyStores:1").build();
            MdsalUtils.initalizeDatastore(LogicalDatastoreType.CONFIGURATION, this.dataBroker, KeyStoresDataUtils.getKeystoresIid(), keyStoreData);
        }
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public String[] getTlsProtocols(String bundleName) {
        String tlsProtocols;
        SslData sslData = this.keyStoresData.getSslData(this.dataBroker, bundleName);
        if (sslData != null && (tlsProtocols = sslData.getTlsProtocols()) != null && !tlsProtocols.isEmpty()) {
            if ((tlsProtocols = tlsProtocols.replace(" ", "")).contains(",")) {
                return tlsProtocols.split(",");
            }
            return new String[]{tlsProtocols};
        }
        return null;
    }
}

