/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cert.impl;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import org.opendaylight.aaa.cert.api.IAaaCertProvider;
import org.opendaylight.aaa.cert.impl.AaaCertMdsalProvider;
import org.opendaylight.aaa.cert.impl.AaaCertProvider;
import org.opendaylight.aaa.cert.impl.DefaultMdsalSslData;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.AaaCertServiceConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.AaaCertRpcService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.GetNodeCertifcateInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.GetNodeCertifcateOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.GetNodeCertifcateOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.GetODLCertificateInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.GetODLCertificateOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.GetODLCertificateOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.GetODLCertificateReqInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.GetODLCertificateReqOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.GetODLCertificateReqOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.SetNodeCertifcateInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.SetNodeCertifcateOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.SetNodeCertifcateOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.SetODLCertifcateInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.SetODLCertifcateOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.SetODLCertifcateOutputBuilder;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AaaCertRpcServiceImpl
implements AaaCertRpcService {
    private static final Logger LOG = LoggerFactory.getLogger(AaaCertRpcServiceImpl.class);
    private final IAaaCertProvider aaaCertProvider;

    public AaaCertRpcServiceImpl(AaaCertServiceConfig aaaCertServiceConfig, DataBroker dataBroker, AAAEncryptionService encryptionSrv) {
        if (aaaCertServiceConfig.isUseConfig().booleanValue()) {
            if (aaaCertServiceConfig.isUseMdsal().booleanValue()) {
                this.aaaCertProvider = new DefaultMdsalSslData(new AaaCertMdsalProvider(dataBroker, encryptionSrv), aaaCertServiceConfig.getBundleName(), aaaCertServiceConfig.getCtlKeystore(), aaaCertServiceConfig.getTrustKeystore());
                LOG.debug("Using default mdsal SslData as aaaCertProvider");
            } else {
                this.aaaCertProvider = new AaaCertProvider(aaaCertServiceConfig.getCtlKeystore(), aaaCertServiceConfig.getTrustKeystore());
                LOG.debug("Using default keystore files as aaaCertProvider");
            }
            LOG.info("AaaCert Rpc Service has been initialized");
        } else {
            this.aaaCertProvider = null;
            LOG.info("AaaCert Rpc Service has not been initialized,change the initial aaa-cert-config data and restart Opendaylight");
        }
    }

    @Override
    public ListenableFuture<RpcResult<GetNodeCertifcateOutput>> getNodeCertifcate(GetNodeCertifcateInput input) {
        SettableFuture futureResult = SettableFuture.create();
        String cert = this.aaaCertProvider.getCertificateTrustStore(input.getNodeAlias(), false);
        if (!Strings.isNullOrEmpty((String)cert)) {
            GetNodeCertifcateOutput nodeCertOutput = new GetNodeCertifcateOutputBuilder().setNodeCert(cert).build();
            futureResult.set((Object)RpcResultBuilder.success((Object)nodeCertOutput).build());
        } else {
            futureResult.set((Object)RpcResultBuilder.failed().build());
        }
        return futureResult;
    }

    @Override
    public ListenableFuture<RpcResult<SetODLCertifcateOutput>> setODLCertifcate(SetODLCertifcateInput input) {
        SettableFuture futureResult = SettableFuture.create();
        if (this.aaaCertProvider.addCertificateODLKeyStore(input.getOdlCertAlias(), input.getOdlCert())) {
            futureResult.set((Object)RpcResultBuilder.success((Object)new SetODLCertifcateOutputBuilder().build()).build());
        } else {
            futureResult.set((Object)RpcResultBuilder.failed().build());
            LOG.info("Error while adding ODL certificate");
        }
        return futureResult;
    }

    @Override
    public ListenableFuture<RpcResult<GetODLCertificateOutput>> getODLCertificate(GetODLCertificateInput input) {
        SettableFuture futureResult = SettableFuture.create();
        String cert = this.aaaCertProvider.getODLKeyStoreCertificate(false);
        if (!Strings.isNullOrEmpty((String)cert)) {
            GetODLCertificateOutput odlCertOutput = new GetODLCertificateOutputBuilder().setOdlCert(cert).build();
            futureResult.set((Object)RpcResultBuilder.success((Object)odlCertOutput).build());
        } else {
            futureResult.set((Object)RpcResultBuilder.failed().build());
        }
        return futureResult;
    }

    @Override
    public ListenableFuture<RpcResult<GetODLCertificateReqOutput>> getODLCertificateReq(GetODLCertificateReqInput input) {
        SettableFuture futureResult = SettableFuture.create();
        String certReq = this.aaaCertProvider.genODLKeyStoreCertificateReq(false);
        if (!Strings.isNullOrEmpty((String)certReq)) {
            GetODLCertificateReqOutput odlCertReqOutput = new GetODLCertificateReqOutputBuilder().setOdlCertReq(certReq).build();
            futureResult.set((Object)RpcResultBuilder.success((Object)odlCertReqOutput).build());
        } else {
            futureResult.set((Object)RpcResultBuilder.failed().build());
        }
        return futureResult;
    }

    @Override
    public ListenableFuture<RpcResult<SetNodeCertifcateOutput>> setNodeCertifcate(SetNodeCertifcateInput input) {
        SettableFuture futureResult = SettableFuture.create();
        if (this.aaaCertProvider.addCertificateTrustStore(input.getNodeAlias(), input.getNodeCert())) {
            futureResult.set((Object)RpcResultBuilder.success((Object)new SetNodeCertifcateOutputBuilder().build()).build());
        } else {
            futureResult.set((Object)RpcResultBuilder.failed().build());
            LOG.info("Error while adding the Node certificate");
        }
        return futureResult;
    }
}

