/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cert.utils;

import java.util.List;
import org.opendaylight.aaa.cert.impl.ODLKeyTool;
import org.opendaylight.aaa.cert.utils.MdsalUtils;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.KeyStores;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.cipher.suite.CipherSuites;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.cipher.suite.CipherSuitesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslDataBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslDataKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.OdlKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.OdlKeystoreBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.TrustKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.TrustKeystoreBuilder;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoresDataUtils {
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoresDataUtils.class);
    public static final String KEYSTORES_DATA_TREE = "KeyStores:1";
    private final AAAEncryptionService encryService;

    public KeyStoresDataUtils(AAAEncryptionService encryService) {
        this.encryService = encryService;
    }

    public static InstanceIdentifier<KeyStores> getKeystoresIid() {
        return InstanceIdentifier.builder(KeyStores.class).build();
    }

    public static InstanceIdentifier<SslData> getSslDataIid() {
        return InstanceIdentifier.create(KeyStores.class).child(SslData.class);
    }

    public static InstanceIdentifier<SslData> getSslDataIid(String bundleName) {
        SslDataKey sslDataKey = new SslDataKey(bundleName);
        return InstanceIdentifier.create(KeyStores.class).child(SslData.class, (Identifier)sslDataKey);
    }

    public static OdlKeystore updateOdlKeystore(OdlKeystore baseOdlKeyStore, byte[] keyStoreBytes) {
        return new OdlKeystoreBuilder(baseOdlKeyStore).setKeystoreFile(keyStoreBytes).build();
    }

    public SslData addSslData(DataBroker dataBroker, String bundleName, OdlKeystore odlKeystore, TrustKeystore trustKeystore, List<CipherSuites> cipherSuites, String tlsProtocols) {
        SslDataKey sslDataKey = new SslDataKey(bundleName);
        SslData sslData = new SslDataBuilder().withKey(sslDataKey).setOdlKeystore(this.encryptOdlKeyStore(odlKeystore)).setTrustKeystore(this.encryptTrustKeystore(trustKeystore)).setCipherSuites(cipherSuites).setTlsProtocols(tlsProtocols).build();
        if (MdsalUtils.put(dataBroker, LogicalDatastoreType.CONFIGURATION, KeyStoresDataUtils.getSslDataIid(bundleName), sslData)) {
            return new SslDataBuilder().withKey(sslDataKey).setOdlKeystore(odlKeystore).setTrustKeystore(trustKeystore).setCipherSuites(cipherSuites).build();
        }
        return null;
    }

    public CipherSuites createCipherSuite(String suiteName) {
        return new CipherSuitesBuilder().setSuiteName(suiteName).build();
    }

    public OdlKeystore createOdlKeystore(String name, String alias, String password, byte[] keyStoreBytes) {
        return new OdlKeystoreBuilder().setKeystoreFile(keyStoreBytes).setAlias(alias).setName(name).setStorePassword(password).build();
    }

    public OdlKeystore createOdlKeystore(String name, String alias, String password, String dname, ODLKeyTool odlKeyTool) {
        return this.createOdlKeystore(name, alias, password, dname, "SHA1WithRSAEncryption", "RSA", 365, 2048, odlKeyTool);
    }

    public OdlKeystore createOdlKeystore(String name, String alias, String password, String dname, String sigAlg, String keyAlg, int validity, int keySize, ODLKeyTool odlKeyTool) {
        byte[] keyStoreBytes = odlKeyTool.convertKeystoreToBytes(odlKeyTool.createKeyStoreWithSelfSignCert(name, password, dname, alias, validity, keyAlg, keySize, sigAlg), password);
        LOG.debug("Odl keystore string {} ", (Object)keyStoreBytes);
        return new OdlKeystoreBuilder().setKeystoreFile(keyStoreBytes).setAlias(alias).setDname(dname).setKeyAlg(keyAlg).setKeysize(keySize).setName(name).setSignAlg(sigAlg).setStorePassword(password).setValidity(validity).build();
    }

    public TrustKeystore createTrustKeystore(String name, String password, byte[] keyStoreBytes) {
        return new TrustKeystoreBuilder().setKeystoreFile(keyStoreBytes).setName(name).setStorePassword(password).build();
    }

    public TrustKeystore createTrustKeystore(String name, String password, ODLKeyTool odlKeyTool) {
        byte[] keyStoreBytes = odlKeyTool.convertKeystoreToBytes(odlKeyTool.createEmptyKeyStore(password), password);
        LOG.debug("trust keystore string {} ", (Object)keyStoreBytes);
        return new TrustKeystoreBuilder().setKeystoreFile(keyStoreBytes).setName(name).setStorePassword(password).build();
    }

    private OdlKeystore decryptOdlKeyStore(OdlKeystore odlKeystore) {
        if (odlKeystore == null) {
            return null;
        }
        OdlKeystoreBuilder odlKeystoreBuilder = new OdlKeystoreBuilder(odlKeystore);
        odlKeystoreBuilder.setKeystoreFile(this.encryService.decrypt(odlKeystore.getKeystoreFile()));
        odlKeystoreBuilder.setStorePassword(this.encryService.decrypt(odlKeystore.getStorePassword()));
        return odlKeystoreBuilder.build();
    }

    private SslData decryptSslData(SslData sslData) {
        if (sslData == null) {
            return null;
        }
        SslDataBuilder sslDataBuilder = new SslDataBuilder(sslData).setOdlKeystore(this.decryptOdlKeyStore(sslData.getOdlKeystore())).setTrustKeystore(this.decryptTrustKeystore(sslData.getTrustKeystore()));
        return sslDataBuilder.build();
    }

    private TrustKeystore decryptTrustKeystore(TrustKeystore trustKeyStore) {
        if (trustKeyStore == null) {
            return null;
        }
        TrustKeystoreBuilder trustKeyStoreBuilder = new TrustKeystoreBuilder(trustKeyStore);
        trustKeyStoreBuilder.setKeystoreFile(this.encryService.decrypt(trustKeyStore.getKeystoreFile()));
        trustKeyStoreBuilder.setStorePassword(this.encryService.decrypt(trustKeyStore.getStorePassword()));
        return trustKeyStoreBuilder.build();
    }

    private OdlKeystore encryptOdlKeyStore(OdlKeystore odlKeystore) {
        OdlKeystoreBuilder odlKeystoreBuilder = new OdlKeystoreBuilder(odlKeystore);
        odlKeystoreBuilder.setKeystoreFile(this.encryService.encrypt(odlKeystore.getKeystoreFile()));
        odlKeystoreBuilder.setStorePassword(this.encryService.encrypt(odlKeystore.getStorePassword()));
        return odlKeystoreBuilder.build();
    }

    private SslData encryptSslData(SslData sslData) {
        SslDataBuilder sslDataBuilder = new SslDataBuilder(sslData).setOdlKeystore(this.encryptOdlKeyStore(sslData.getOdlKeystore())).setTrustKeystore(this.encryptTrustKeystore(sslData.getTrustKeystore()));
        return sslDataBuilder.build();
    }

    private TrustKeystore encryptTrustKeystore(TrustKeystore trustKeyStore) {
        TrustKeystoreBuilder trustKeyStoreBuilder = new TrustKeystoreBuilder(trustKeyStore);
        trustKeyStoreBuilder.setKeystoreFile(this.encryService.encrypt(trustKeyStore.getKeystoreFile()));
        trustKeyStoreBuilder.setStorePassword(this.encryService.encrypt(trustKeyStore.getStorePassword()));
        return trustKeyStoreBuilder.build();
    }

    public SslData getSslData(DataBroker dataBroker, String bundleName) {
        InstanceIdentifier<SslData> sslDataIid = KeyStoresDataUtils.getSslDataIid(bundleName);
        return this.decryptSslData(MdsalUtils.read(dataBroker, LogicalDatastoreType.CONFIGURATION, sslDataIid));
    }

    public boolean removeSslData(DataBroker dataBroker, String bundleName) {
        InstanceIdentifier<SslData> sslDataIid = KeyStoresDataUtils.getSslDataIid(bundleName);
        return MdsalUtils.delete(dataBroker, LogicalDatastoreType.CONFIGURATION, sslDataIid);
    }

    public boolean updateSslData(DataBroker dataBroker, SslData sslData) {
        InstanceIdentifier<SslData> sslDataIid = KeyStoresDataUtils.getSslDataIid(sslData.getBundleName());
        return MdsalUtils.merge(dataBroker, LogicalDatastoreType.CONFIGURATION, sslDataIid, this.encryptSslData(sslData));
    }

    public boolean updateSslDataCipherSuites(DataBroker dataBroker, SslData baseSslData, List<CipherSuites> cipherSuites) {
        SslDataBuilder sslDataBuilder = new SslDataBuilder(baseSslData).setCipherSuites(cipherSuites);
        return this.updateSslData(dataBroker, sslDataBuilder.build());
    }

    public boolean updateSslDataOdlKeystore(DataBroker dataBroker, SslData baseSslData, OdlKeystore odlKeyStore) {
        SslDataBuilder sslDataBuilder = new SslDataBuilder(baseSslData).setOdlKeystore(odlKeyStore);
        return this.updateSslData(dataBroker, sslDataBuilder.build());
    }

    public boolean updateSslDataTrustKeystore(DataBroker dataBroker, SslData baseSslData, TrustKeystore trustKeyStore) {
        SslDataBuilder sslDataBuilder = new SslDataBuilder(baseSslData).setTrustKeystore(trustKeyStore);
        return this.updateSslData(dataBroker, sslDataBuilder.build());
    }

    public TrustKeystore updateTrustKeystore(TrustKeystore baseTrustKeyStore, byte[] keyStoreBytes) {
        return new TrustKeystoreBuilder(baseTrustKeyStore).setKeystoreFile(keyStoreBytes).build();
    }
}

