/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.KeyStores;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class KeyStoresBuilder
implements Builder<KeyStores> {
    private String _id;
    private List<SslData> _sslData;
    Map<Class<? extends Augmentation<KeyStores>>, Augmentation<KeyStores>> augmentation = Collections.emptyMap();

    public KeyStoresBuilder() {
    }

    public KeyStoresBuilder(KeyStores base) {
        Map aug;
        this._id = base.getId();
        this._sslData = base.getSslData();
        if (base instanceof KeyStoresImpl) {
            KeyStoresImpl impl = (KeyStoresImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<KeyStores>>, Augmentation<KeyStores>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<KeyStores>>, Augmentation<KeyStores>>(aug);
        }
    }

    public String getId() {
        return this._id;
    }

    public List<SslData> getSslData() {
        return this._sslData;
    }

    public <E$$ extends Augmentation<KeyStores>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public KeyStoresBuilder setId(String value) {
        this._id = value;
        return this;
    }

    public KeyStoresBuilder setSslData(List<SslData> values) {
        this._sslData = values;
        return this;
    }

    public KeyStoresBuilder addAugmentation(Class<? extends Augmentation<KeyStores>> augmentationType, Augmentation<KeyStores> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<KeyStores>>, Augmentation<KeyStores>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public KeyStoresBuilder removeAugmentation(Class<? extends Augmentation<KeyStores>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public KeyStores build() {
        return new KeyStoresImpl(this);
    }

    private static final class KeyStoresImpl
    implements KeyStores {
        private final String _id;
        private final List<SslData> _sslData;
        private Map<Class<? extends Augmentation<KeyStores>>, Augmentation<KeyStores>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        KeyStoresImpl(KeyStoresBuilder base) {
            this._id = base.getId();
            this._sslData = base.getSslData();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<KeyStores> getImplementedInterface() {
            return KeyStores.class;
        }

        @Override
        public String getId() {
            return this._id;
        }

        @Override
        public List<SslData> getSslData() {
            return this._sslData;
        }

        public <E$$ extends Augmentation<KeyStores>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._id);
            result = 31 * result + Objects.hashCode(this._sslData);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!KeyStores.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            KeyStores other = (KeyStores)obj;
            if (!Objects.equals(this._id, other.getId())) {
                return false;
            }
            if (!Objects.equals(this._sslData, other.getSslData())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                KeyStoresImpl otherImpl = (KeyStoresImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<KeyStores>>, Augmentation<KeyStores>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"KeyStores");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_id", (Object)this._id);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sslData", this._sslData);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

