/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.AaaCertServiceConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.CtlKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.TrustKeystore;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AaaCertServiceConfigBuilder
implements Builder<AaaCertServiceConfig> {
    private String _bundleName;
    private CtlKeystore _ctlKeystore;
    private TrustKeystore _trustKeystore;
    private Boolean _useConfig;
    private Boolean _useMdsal;
    Map<Class<? extends Augmentation<AaaCertServiceConfig>>, Augmentation<AaaCertServiceConfig>> augmentation = Collections.emptyMap();

    public AaaCertServiceConfigBuilder() {
    }

    public AaaCertServiceConfigBuilder(AaaCertServiceConfig base) {
        Map aug;
        this._bundleName = base.getBundleName();
        this._ctlKeystore = base.getCtlKeystore();
        this._trustKeystore = base.getTrustKeystore();
        this._useConfig = base.isUseConfig();
        this._useMdsal = base.isUseMdsal();
        if (base instanceof AaaCertServiceConfigImpl) {
            AaaCertServiceConfigImpl impl = (AaaCertServiceConfigImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<AaaCertServiceConfig>>, Augmentation<AaaCertServiceConfig>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AaaCertServiceConfig>>, Augmentation<AaaCertServiceConfig>>(aug);
        }
    }

    public String getBundleName() {
        return this._bundleName;
    }

    public CtlKeystore getCtlKeystore() {
        return this._ctlKeystore;
    }

    public TrustKeystore getTrustKeystore() {
        return this._trustKeystore;
    }

    public Boolean isUseConfig() {
        return this._useConfig;
    }

    public Boolean isUseMdsal() {
        return this._useMdsal;
    }

    public <E$$ extends Augmentation<AaaCertServiceConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public AaaCertServiceConfigBuilder setBundleName(String value) {
        this._bundleName = value;
        return this;
    }

    public AaaCertServiceConfigBuilder setCtlKeystore(CtlKeystore value) {
        this._ctlKeystore = value;
        return this;
    }

    public AaaCertServiceConfigBuilder setTrustKeystore(TrustKeystore value) {
        this._trustKeystore = value;
        return this;
    }

    public AaaCertServiceConfigBuilder setUseConfig(Boolean value) {
        this._useConfig = value;
        return this;
    }

    public AaaCertServiceConfigBuilder setUseMdsal(Boolean value) {
        this._useMdsal = value;
        return this;
    }

    public AaaCertServiceConfigBuilder addAugmentation(Class<? extends Augmentation<AaaCertServiceConfig>> augmentationType, Augmentation<AaaCertServiceConfig> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AaaCertServiceConfig>>, Augmentation<AaaCertServiceConfig>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AaaCertServiceConfigBuilder removeAugmentation(Class<? extends Augmentation<AaaCertServiceConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public AaaCertServiceConfig build() {
        return new AaaCertServiceConfigImpl(this);
    }

    private static final class AaaCertServiceConfigImpl
    implements AaaCertServiceConfig {
        private final String _bundleName;
        private final CtlKeystore _ctlKeystore;
        private final TrustKeystore _trustKeystore;
        private final Boolean _useConfig;
        private final Boolean _useMdsal;
        private Map<Class<? extends Augmentation<AaaCertServiceConfig>>, Augmentation<AaaCertServiceConfig>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        AaaCertServiceConfigImpl(AaaCertServiceConfigBuilder base) {
            this._bundleName = base.getBundleName();
            this._ctlKeystore = base.getCtlKeystore();
            this._trustKeystore = base.getTrustKeystore();
            this._useConfig = base.isUseConfig();
            this._useMdsal = base.isUseMdsal();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<AaaCertServiceConfig> getImplementedInterface() {
            return AaaCertServiceConfig.class;
        }

        @Override
        public String getBundleName() {
            return this._bundleName;
        }

        @Override
        public CtlKeystore getCtlKeystore() {
            return this._ctlKeystore;
        }

        @Override
        public TrustKeystore getTrustKeystore() {
            return this._trustKeystore;
        }

        @Override
        public Boolean isUseConfig() {
            return this._useConfig;
        }

        @Override
        public Boolean isUseMdsal() {
            return this._useMdsal;
        }

        public <E$$ extends Augmentation<AaaCertServiceConfig>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bundleName);
            result = 31 * result + Objects.hashCode(this._ctlKeystore);
            result = 31 * result + Objects.hashCode(this._trustKeystore);
            result = 31 * result + Objects.hashCode(this._useConfig);
            result = 31 * result + Objects.hashCode(this._useMdsal);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AaaCertServiceConfig.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            AaaCertServiceConfig other = (AaaCertServiceConfig)obj;
            if (!Objects.equals(this._bundleName, other.getBundleName())) {
                return false;
            }
            if (!Objects.equals(this._ctlKeystore, other.getCtlKeystore())) {
                return false;
            }
            if (!Objects.equals(this._trustKeystore, other.getTrustKeystore())) {
                return false;
            }
            if (!Objects.equals(this._useConfig, other.isUseConfig())) {
                return false;
            }
            if (!Objects.equals(this._useMdsal, other.isUseMdsal())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AaaCertServiceConfigImpl otherImpl = (AaaCertServiceConfigImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<AaaCertServiceConfig>>, Augmentation<AaaCertServiceConfig>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"AaaCertServiceConfig");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_bundleName", (Object)this._bundleName);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ctlKeystore", (Object)this._ctlKeystore);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_trustKeystore", (Object)this._trustKeystore);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_useConfig", (Object)this._useConfig);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_useMdsal", (Object)this._useMdsal);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

