/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.CtlKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.ctlkeystore.CipherSuites;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CtlKeystoreBuilder
implements Builder<CtlKeystore> {
    private String _alias;
    private List<CipherSuites> _cipherSuites;
    private String _dname;
    private String _keyAlg;
    private Integer _keysize;
    private String _name;
    private String _signAlg;
    private String _storePassword;
    private String _tlsProtocols;
    private Integer _validity;
    Map<Class<? extends Augmentation<CtlKeystore>>, Augmentation<CtlKeystore>> augmentation = Collections.emptyMap();

    public CtlKeystoreBuilder() {
    }

    public CtlKeystoreBuilder(CtlKeystore base) {
        Map aug;
        this._alias = base.getAlias();
        this._cipherSuites = base.getCipherSuites();
        this._dname = base.getDname();
        this._keyAlg = base.getKeyAlg();
        this._keysize = base.getKeysize();
        this._name = base.getName();
        this._signAlg = base.getSignAlg();
        this._storePassword = base.getStorePassword();
        this._tlsProtocols = base.getTlsProtocols();
        this._validity = base.getValidity();
        if (base instanceof CtlKeystoreImpl) {
            CtlKeystoreImpl impl = (CtlKeystoreImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<CtlKeystore>>, Augmentation<CtlKeystore>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CtlKeystore>>, Augmentation<CtlKeystore>>(aug);
        }
    }

    public String getAlias() {
        return this._alias;
    }

    public List<CipherSuites> getCipherSuites() {
        return this._cipherSuites;
    }

    public String getDname() {
        return this._dname;
    }

    public String getKeyAlg() {
        return this._keyAlg;
    }

    public Integer getKeysize() {
        return this._keysize;
    }

    public String getName() {
        return this._name;
    }

    public String getSignAlg() {
        return this._signAlg;
    }

    public String getStorePassword() {
        return this._storePassword;
    }

    public String getTlsProtocols() {
        return this._tlsProtocols;
    }

    public Integer getValidity() {
        return this._validity;
    }

    public <E$$ extends Augmentation<CtlKeystore>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public CtlKeystoreBuilder setAlias(String value) {
        this._alias = value;
        return this;
    }

    public CtlKeystoreBuilder setCipherSuites(List<CipherSuites> values) {
        this._cipherSuites = values;
        return this;
    }

    public CtlKeystoreBuilder setDname(String value) {
        this._dname = value;
        return this;
    }

    public CtlKeystoreBuilder setKeyAlg(String value) {
        this._keyAlg = value;
        return this;
    }

    public CtlKeystoreBuilder setKeysize(Integer value) {
        this._keysize = value;
        return this;
    }

    public CtlKeystoreBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public CtlKeystoreBuilder setSignAlg(String value) {
        this._signAlg = value;
        return this;
    }

    public CtlKeystoreBuilder setStorePassword(String value) {
        this._storePassword = value;
        return this;
    }

    public CtlKeystoreBuilder setTlsProtocols(String value) {
        this._tlsProtocols = value;
        return this;
    }

    public CtlKeystoreBuilder setValidity(Integer value) {
        this._validity = value;
        return this;
    }

    public CtlKeystoreBuilder addAugmentation(Class<? extends Augmentation<CtlKeystore>> augmentationType, Augmentation<CtlKeystore> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CtlKeystore>>, Augmentation<CtlKeystore>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public CtlKeystoreBuilder removeAugmentation(Class<? extends Augmentation<CtlKeystore>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public CtlKeystore build() {
        return new CtlKeystoreImpl(this);
    }

    private static final class CtlKeystoreImpl
    implements CtlKeystore {
        private final String _alias;
        private final List<CipherSuites> _cipherSuites;
        private final String _dname;
        private final String _keyAlg;
        private final Integer _keysize;
        private final String _name;
        private final String _signAlg;
        private final String _storePassword;
        private final String _tlsProtocols;
        private final Integer _validity;
        private Map<Class<? extends Augmentation<CtlKeystore>>, Augmentation<CtlKeystore>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        CtlKeystoreImpl(CtlKeystoreBuilder base) {
            this._alias = base.getAlias();
            this._cipherSuites = base.getCipherSuites();
            this._dname = base.getDname();
            this._keyAlg = base.getKeyAlg();
            this._keysize = base.getKeysize();
            this._name = base.getName();
            this._signAlg = base.getSignAlg();
            this._storePassword = base.getStorePassword();
            this._tlsProtocols = base.getTlsProtocols();
            this._validity = base.getValidity();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<CtlKeystore> getImplementedInterface() {
            return CtlKeystore.class;
        }

        @Override
        public String getAlias() {
            return this._alias;
        }

        @Override
        public List<CipherSuites> getCipherSuites() {
            return this._cipherSuites;
        }

        @Override
        public String getDname() {
            return this._dname;
        }

        @Override
        public String getKeyAlg() {
            return this._keyAlg;
        }

        @Override
        public Integer getKeysize() {
            return this._keysize;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getSignAlg() {
            return this._signAlg;
        }

        @Override
        public String getStorePassword() {
            return this._storePassword;
        }

        @Override
        public String getTlsProtocols() {
            return this._tlsProtocols;
        }

        @Override
        public Integer getValidity() {
            return this._validity;
        }

        public <E$$ extends Augmentation<CtlKeystore>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._alias);
            result = 31 * result + Objects.hashCode(this._cipherSuites);
            result = 31 * result + Objects.hashCode(this._dname);
            result = 31 * result + Objects.hashCode(this._keyAlg);
            result = 31 * result + Objects.hashCode(this._keysize);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._signAlg);
            result = 31 * result + Objects.hashCode(this._storePassword);
            result = 31 * result + Objects.hashCode(this._tlsProtocols);
            result = 31 * result + Objects.hashCode(this._validity);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!CtlKeystore.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            CtlKeystore other = (CtlKeystore)obj;
            if (!Objects.equals(this._alias, other.getAlias())) {
                return false;
            }
            if (!Objects.equals(this._cipherSuites, other.getCipherSuites())) {
                return false;
            }
            if (!Objects.equals(this._dname, other.getDname())) {
                return false;
            }
            if (!Objects.equals(this._keyAlg, other.getKeyAlg())) {
                return false;
            }
            if (!Objects.equals(this._keysize, other.getKeysize())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._signAlg, other.getSignAlg())) {
                return false;
            }
            if (!Objects.equals(this._storePassword, other.getStorePassword())) {
                return false;
            }
            if (!Objects.equals(this._tlsProtocols, other.getTlsProtocols())) {
                return false;
            }
            if (!Objects.equals(this._validity, other.getValidity())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                CtlKeystoreImpl otherImpl = (CtlKeystoreImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<CtlKeystore>>, Augmentation<CtlKeystore>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"CtlKeystore");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_alias", (Object)this._alias);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_cipherSuites", this._cipherSuites);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_dname", (Object)this._dname);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_keyAlg", (Object)this._keyAlg);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_keysize", (Object)this._keysize);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)this._name);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_signAlg", (Object)this._signAlg);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_storePassword", (Object)this._storePassword);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_tlsProtocols", (Object)this._tlsProtocols);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_validity", (Object)this._validity);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

