/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.notification.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.netconf.mdsal.notification.impl.OperationalDatastoreListener;
import org.opendaylight.netconf.notifications.BaseNotificationPublisherRegistration;
import org.opendaylight.netconf.notifications.NetconfNotificationCollector;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.NetconfState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Capabilities;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfCapabilityChangeBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.ChangedByBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.changed.by.ServerOrUser;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.changed.by.server.or.user.ServerBuilder;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CapabilityChangeNotificationProducer
extends OperationalDatastoreListener<Capabilities>
implements AutoCloseable {
    private static final InstanceIdentifier<Capabilities> CAPABILITIES_INSTANCE_IDENTIFIER = InstanceIdentifier.create(NetconfState.class).child(Capabilities.class);
    private static final Logger LOG = LoggerFactory.getLogger(CapabilityChangeNotificationProducer.class);
    private final BaseNotificationPublisherRegistration baseNotificationPublisherRegistration;
    private final ListenerRegistration capabilityChangeListenerRegistration;

    public CapabilityChangeNotificationProducer(NetconfNotificationCollector netconfNotificationCollector, DataBroker dataBroker) {
        super(CAPABILITIES_INSTANCE_IDENTIFIER);
        this.baseNotificationPublisherRegistration = netconfNotificationCollector.registerBaseNotificationPublisher();
        this.capabilityChangeListenerRegistration = this.registerOnChanges(dataBroker);
    }

    public void onDataTreeChanged(@Nonnull Collection<DataTreeModification<Capabilities>> changes) {
        block4: for (DataTreeModification<Capabilities> change : changes) {
            DataObjectModification rootNode = change.getRootNode();
            DataObjectModification.ModificationType modificationType = rootNode.getModificationType();
            switch (modificationType) {
                case WRITE: {
                    Capabilities dataAfter = (Capabilities)rootNode.getDataAfter();
                    Capabilities dataBefore = (Capabilities)rootNode.getDataBefore();
                    ImmutableSet before = dataBefore != null ? ImmutableSet.copyOf((Collection)dataBefore.getCapability()) : Collections.emptySet();
                    ImmutableSet after = dataAfter != null ? ImmutableSet.copyOf((Collection)dataAfter.getCapability()) : Collections.emptySet();
                    Sets.SetView added = Sets.difference((Set)after, (Set)before);
                    Sets.SetView removed = Sets.difference((Set)before, (Set)after);
                    this.publishNotification((Set<Uri>)added, (Set<Uri>)removed);
                    continue block4;
                }
                case DELETE: {
                    Capabilities dataBeforeDelete = (Capabilities)rootNode.getDataBefore();
                    if (dataBeforeDelete == null) continue block4;
                    ImmutableSet removed = ImmutableSet.copyOf((Collection)dataBeforeDelete.getCapability());
                    this.publishNotification(Collections.emptySet(), (Set<Uri>)removed);
                    continue block4;
                }
            }
            LOG.debug("Received intentionally unhandled type: {}.", (Object)modificationType);
        }
    }

    private void publishNotification(Set<Uri> added, Set<Uri> removed) {
        NetconfCapabilityChangeBuilder netconfCapabilityChangeBuilder = new NetconfCapabilityChangeBuilder();
        netconfCapabilityChangeBuilder.setChangedBy(new ChangedByBuilder().setServerOrUser((ServerOrUser)new ServerBuilder().setServer(Boolean.valueOf(true)).build()).build());
        netconfCapabilityChangeBuilder.setAddedCapability((List)ImmutableList.copyOf(added));
        netconfCapabilityChangeBuilder.setDeletedCapability((List)ImmutableList.copyOf(removed));
        netconfCapabilityChangeBuilder.setModifiedCapability(Collections.emptyList());
        this.baseNotificationPublisherRegistration.onCapabilityChanged(netconfCapabilityChangeBuilder.build());
    }

    @Override
    public void close() {
        if (this.baseNotificationPublisherRegistration != null) {
            this.baseNotificationPublisherRegistration.close();
        }
        if (this.capabilityChangeListenerRegistration != null) {
            this.capabilityChangeListenerRegistration.close();
        }
    }
}

