/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.notification.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.netconf.mdsal.notification.impl.ops.NotificationsTransformUtil;
import org.opendaylight.netconf.notifications.BaseNotificationPublisherRegistration;
import org.opendaylight.netconf.notifications.NetconfNotification;
import org.opendaylight.netconf.notifications.NetconfNotificationCollector;
import org.opendaylight.netconf.notifications.NetconfNotificationListener;
import org.opendaylight.netconf.notifications.NetconfNotificationRegistry;
import org.opendaylight.netconf.notifications.NotificationListenerRegistration;
import org.opendaylight.netconf.notifications.NotificationPublisherRegistration;
import org.opendaylight.netconf.notifications.NotificationRegistration;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.StreamNameType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.Streams;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.StreamsBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.Stream;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.StreamBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.StreamKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfCapabilityChange;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionEnd;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionStart;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class NetconfNotificationManager
implements NetconfNotificationCollector,
NetconfNotificationRegistry,
NetconfNotificationListener,
AutoCloseable {
    public static final StreamNameType BASE_STREAM_NAME = new StreamNameType("NETCONF");
    public static final Stream BASE_NETCONF_STREAM = new StreamBuilder().setName(BASE_STREAM_NAME).withKey(new StreamKey(BASE_STREAM_NAME)).setReplaySupport(Boolean.valueOf(false)).setDescription("Default Event Stream").build();
    private static final Logger LOG = LoggerFactory.getLogger(NetconfNotificationManager.class);
    @GuardedBy(value="this")
    private final Multimap<StreamNameType, GenericNotificationListenerReg> notificationListeners = HashMultimap.create();
    @GuardedBy(value="this")
    private final Set<NetconfNotificationCollector.NetconfNotificationStreamListener> streamListeners = new HashSet<NetconfNotificationCollector.NetconfNotificationStreamListener>();
    @GuardedBy(value="this")
    private final Map<StreamNameType, Stream> streamMetadata = new HashMap<StreamNameType, Stream>();
    @GuardedBy(value="this")
    private final Multiset<StreamNameType> availableStreams = HashMultiset.create();
    @GuardedBy(value="this")
    private final Set<GenericNotificationPublisherReg> notificationPublishers = new HashSet<GenericNotificationPublisherReg>();

    public synchronized void onNotification(StreamNameType stream, NetconfNotification notification) {
        LOG.debug("Notification of type {} detected", (Object)stream);
        if (LOG.isTraceEnabled()) {
            LOG.debug("Notification of type {} detected: {}", (Object)stream, (Object)notification);
        }
        for (GenericNotificationListenerReg listenerReg : this.notificationListeners.get((Object)BASE_STREAM_NAME)) {
            listenerReg.getListener().onNotification(BASE_STREAM_NAME, notification);
        }
    }

    public synchronized NotificationListenerRegistration registerNotificationListener(final StreamNameType stream, NetconfNotificationListener listener) {
        Preconditions.checkNotNull((Object)stream);
        Preconditions.checkNotNull((Object)listener);
        LOG.trace("Notification listener registered for stream: {}", (Object)stream);
        GenericNotificationListenerReg genericNotificationListenerReg = new GenericNotificationListenerReg(listener){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                NetconfNotificationManager netconfNotificationManager = NetconfNotificationManager.this;
                synchronized (netconfNotificationManager) {
                    LOG.trace("Notification listener unregistered for stream: {}", (Object)stream);
                    super.close();
                }
            }
        };
        this.notificationListeners.put((Object)BASE_STREAM_NAME, (Object)genericNotificationListenerReg);
        return genericNotificationListenerReg;
    }

    public synchronized Streams getNotificationPublishers() {
        return new StreamsBuilder().setStream((List)Lists.newArrayList(this.streamMetadata.values())).build();
    }

    public synchronized boolean isStreamAvailable(StreamNameType streamNameType) {
        return this.availableStreams.contains((Object)streamNameType);
    }

    public synchronized NotificationRegistration registerStreamListener(NetconfNotificationCollector.NetconfNotificationStreamListener listener) {
        this.streamListeners.add(listener);
        for (Stream availableStream : this.streamMetadata.values()) {
            listener.onStreamRegistered(availableStream);
        }
        return () -> {
            NetconfNotificationManager netconfNotificationManager = this;
            synchronized (netconfNotificationManager) {
                this.streamListeners.remove(listener);
            }
        };
    }

    @Override
    public synchronized void close() {
        for (GenericNotificationListenerReg genericNotificationListenerReg : this.notificationListeners.values()) {
            genericNotificationListenerReg.close();
        }
        this.notificationListeners.clear();
        for (GenericNotificationPublisherReg notificationPublisher : this.notificationPublishers) {
            notificationPublisher.close();
        }
        this.notificationPublishers.clear();
        this.streamListeners.clear();
    }

    public synchronized NotificationPublisherRegistration registerNotificationPublisher(Stream stream) {
        Preconditions.checkNotNull((Object)stream);
        StreamNameType streamName = stream.getName();
        LOG.debug("Notification publisher registered for stream: {}", (Object)streamName);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Notification publisher registered for stream: {}", (Object)stream);
        }
        if (this.streamMetadata.containsKey(streamName)) {
            LOG.warn("Notification stream {} already registered as: {}. Will be reused", (Object)streamName, (Object)this.streamMetadata.get(streamName));
        } else {
            this.streamMetadata.put(streamName, stream);
        }
        this.availableStreams.add((Object)streamName);
        GenericNotificationPublisherReg genericNotificationPublisherReg = new GenericNotificationPublisherReg(this, streamName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                NetconfNotificationManager netconfNotificationManager = NetconfNotificationManager.this;
                synchronized (netconfNotificationManager) {
                    super.close();
                }
            }
        };
        this.notificationPublishers.add(genericNotificationPublisherReg);
        this.notifyStreamAdded(stream);
        return genericNotificationPublisherReg;
    }

    private void unregisterNotificationPublisher(StreamNameType streamName, GenericNotificationPublisherReg genericNotificationPublisherReg) {
        this.availableStreams.remove((Object)streamName);
        this.notificationPublishers.remove(genericNotificationPublisherReg);
        LOG.debug("Notification publisher unregistered for stream: {}", (Object)streamName);
        if (!this.isStreamAvailable(streamName)) {
            LOG.debug("Notification stream: {} became unavailable", (Object)streamName);
            this.streamMetadata.remove(streamName);
            this.notifyStreamRemoved(streamName);
        }
    }

    private synchronized void notifyStreamAdded(Stream stream) {
        for (NetconfNotificationCollector.NetconfNotificationStreamListener streamListener : this.streamListeners) {
            streamListener.onStreamRegistered(stream);
        }
    }

    private synchronized void notifyStreamRemoved(StreamNameType stream) {
        for (NetconfNotificationCollector.NetconfNotificationStreamListener streamListener : this.streamListeners) {
            streamListener.onStreamUnregistered(stream);
        }
    }

    public BaseNotificationPublisherRegistration registerBaseNotificationPublisher() {
        NotificationPublisherRegistration notificationPublisherRegistration = this.registerNotificationPublisher(BASE_NETCONF_STREAM);
        return new BaseNotificationPublisherReg(notificationPublisherRegistration);
    }

    private class GenericNotificationListenerReg
    implements NotificationListenerRegistration {
        private final NetconfNotificationListener listener;

        GenericNotificationListenerReg(NetconfNotificationListener listener) {
            this.listener = listener;
        }

        public NetconfNotificationListener getListener() {
            return this.listener;
        }

        public void close() {
            NetconfNotificationManager.this.notificationListeners.remove((Object)BASE_STREAM_NAME, (Object)this);
        }
    }

    private static class BaseNotificationPublisherReg
    implements BaseNotificationPublisherRegistration {
        static final SchemaPath CAPABILITY_CHANGE_SCHEMA_PATH = SchemaPath.create((boolean)true, (QName[])new QName[]{NetconfCapabilityChange.QNAME});
        static final SchemaPath SESSION_START_PATH = SchemaPath.create((boolean)true, (QName[])new QName[]{NetconfSessionStart.QNAME});
        static final SchemaPath SESSION_END_PATH = SchemaPath.create((boolean)true, (QName[])new QName[]{NetconfSessionEnd.QNAME});
        private final NotificationPublisherRegistration baseRegistration;

        BaseNotificationPublisherReg(NotificationPublisherRegistration baseRegistration) {
            this.baseRegistration = baseRegistration;
        }

        public void close() {
            this.baseRegistration.close();
        }

        private static NetconfNotification serializeNotification(Notification notification, SchemaPath path) {
            return NotificationsTransformUtil.transform(notification, path);
        }

        public void onCapabilityChanged(NetconfCapabilityChange capabilityChange) {
            this.baseRegistration.onNotification(BASE_STREAM_NAME, BaseNotificationPublisherReg.serializeNotification((Notification)capabilityChange, CAPABILITY_CHANGE_SCHEMA_PATH));
        }

        public void onSessionStarted(NetconfSessionStart start) {
            this.baseRegistration.onNotification(BASE_STREAM_NAME, BaseNotificationPublisherReg.serializeNotification((Notification)start, SESSION_START_PATH));
        }

        public void onSessionEnded(NetconfSessionEnd end) {
            this.baseRegistration.onNotification(BASE_STREAM_NAME, BaseNotificationPublisherReg.serializeNotification((Notification)end, SESSION_END_PATH));
        }
    }

    private static class GenericNotificationPublisherReg
    implements NotificationPublisherRegistration {
        private NetconfNotificationManager baseListener;
        private final StreamNameType registeredStream;

        GenericNotificationPublisherReg(NetconfNotificationManager baseListener, StreamNameType registeredStream) {
            this.baseListener = baseListener;
            this.registeredStream = registeredStream;
        }

        public void close() {
            this.baseListener.unregisterNotificationPublisher(this.registeredStream, this);
            this.baseListener = null;
        }

        public void onNotification(StreamNameType stream, NetconfNotification notification) {
            Preconditions.checkState((this.baseListener != null ? 1 : 0) != 0, (Object)"Already closed");
            Preconditions.checkArgument((boolean)stream.equals((Object)this.registeredStream));
            this.baseListener.onNotification(stream, notification);
        }
    }
}

