/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.notification.impl;

import java.util.Collections;
import java.util.Set;
import org.opendaylight.controller.sal.common.util.NoopAutoCloseable;
import org.opendaylight.netconf.api.capability.Capability;
import org.opendaylight.netconf.api.monitoring.CapabilityListener;
import org.opendaylight.netconf.mapping.api.NetconfOperationService;
import org.opendaylight.netconf.mapping.api.NetconfOperationServiceFactory;
import org.opendaylight.netconf.mapping.api.NetconfOperationServiceFactoryListener;
import org.opendaylight.netconf.mdsal.notification.impl.NetconfNotificationOperationService;
import org.opendaylight.netconf.notifications.NetconfNotificationRegistry;

public class NetconfNotificationOperationServiceFactory
implements NetconfOperationServiceFactory,
AutoCloseable {
    private final NetconfNotificationRegistry netconfNotificationRegistry;
    private final NetconfOperationServiceFactoryListener netconfOperationServiceFactoryListener;

    public NetconfNotificationOperationServiceFactory(NetconfNotificationRegistry netconfNotificationRegistry, NetconfOperationServiceFactoryListener netconfOperationServiceFactoryListener) {
        this.netconfNotificationRegistry = netconfNotificationRegistry;
        this.netconfOperationServiceFactoryListener = netconfOperationServiceFactoryListener;
        this.netconfOperationServiceFactoryListener.onAddNetconfOperationServiceFactory((NetconfOperationServiceFactory)this);
    }

    public Set<Capability> getCapabilities() {
        return Collections.emptySet();
    }

    public NetconfOperationService createService(String netconfSessionIdForReporting) {
        return new NetconfNotificationOperationService(netconfSessionIdForReporting, this.netconfNotificationRegistry);
    }

    public AutoCloseable registerCapabilityListener(CapabilityListener listener) {
        return NoopAutoCloseable.INSTANCE;
    }

    @Override
    public void close() {
        this.netconfOperationServiceFactoryListener.onRemoveNetconfOperationServiceFactory((NetconfOperationServiceFactory)this);
    }
}

