/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.notification.impl;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.notifications.NetconfNotificationCollector;
import org.opendaylight.netconf.notifications.NotificationRegistration;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.StreamNameType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.Netconf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.Streams;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.Stream;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.StreamKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NotificationToMdsalWriter
implements AutoCloseable,
NetconfNotificationCollector.NetconfNotificationStreamListener {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationToMdsalWriter.class);
    private static final InstanceIdentifier<Streams> STREAMS = InstanceIdentifier.builder(Netconf.class).child(Streams.class).build();
    private final NetconfNotificationCollector netconfNotificationCollector;
    private final DataBroker dataBroker;
    private NotificationRegistration notificationRegistration;

    public NotificationToMdsalWriter(NetconfNotificationCollector netconfNotificationCollector, DataBroker dataBroker) {
        this.netconfNotificationCollector = netconfNotificationCollector;
        this.dataBroker = dataBroker;
    }

    @Override
    public void close() {
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        tx.delete(LogicalDatastoreType.OPERATIONAL, InstanceIdentifier.create(Netconf.class));
        tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo info) {
                LOG.debug("Streams cleared successfully");
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("Unable to clear streams", throwable);
            }
        }, MoreExecutors.directExecutor());
        this.notificationRegistration.close();
    }

    public void start() {
        this.notificationRegistration = this.netconfNotificationCollector.registerStreamListener((NetconfNotificationCollector.NetconfNotificationStreamListener)this);
    }

    public void onStreamRegistered(Stream stream) {
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        KeyedInstanceIdentifier streamIdentifier = STREAMS.child(Stream.class, (Identifier)stream.key());
        tx.merge(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)streamIdentifier, (DataObject)stream, true);
        try {
            tx.commit().get();
            LOG.debug("Stream {} registered successfully.", (Object)stream.getName());
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Unable to register stream {}.", (Object)stream, (Object)e);
        }
    }

    public void onStreamUnregistered(StreamNameType stream) {
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        KeyedInstanceIdentifier streamIdentifier = STREAMS.child(Stream.class, (Identifier)new StreamKey(stream));
        tx.delete(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)streamIdentifier);
        try {
            tx.commit().get();
            LOG.debug("Stream {} unregistered successfully.", (Object)stream);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Unable to unregister stream {}", (Object)stream, (Object)e);
        }
    }
}

