/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.notification.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.netconf.mdsal.notification.impl.OperationalDatastoreListener;
import org.opendaylight.netconf.notifications.BaseNotificationPublisherRegistration;
import org.opendaylight.netconf.notifications.NetconfNotificationCollector;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdOrZeroType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.NetconfState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Sessions;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.Session;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionEnd;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionEndBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionStart;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionStartBuilder;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionNotificationProducer
extends OperationalDatastoreListener<Session> {
    private static final InstanceIdentifier<Session> SESSION_INSTANCE_IDENTIFIER = InstanceIdentifier.create(NetconfState.class).child(Sessions.class).child(Session.class);
    private static final Logger LOG = LoggerFactory.getLogger(SessionNotificationProducer.class);
    private final BaseNotificationPublisherRegistration baseNotificationPublisherRegistration;
    private final ListenerRegistration sessionListenerRegistration;

    public SessionNotificationProducer(NetconfNotificationCollector netconfNotificationCollector, DataBroker dataBroker) {
        super(SESSION_INSTANCE_IDENTIFIER);
        this.baseNotificationPublisherRegistration = netconfNotificationCollector.registerBaseNotificationPublisher();
        this.sessionListenerRegistration = this.registerOnChanges(dataBroker);
    }

    public void onDataTreeChanged(@Nonnull Collection<DataTreeModification<Session>> changes) {
        block4: for (DataTreeModification<Session> change : changes) {
            DataObjectModification rootNode = change.getRootNode();
            DataObjectModification.ModificationType modificationType = rootNode.getModificationType();
            switch (modificationType) {
                case WRITE: {
                    Session created = (Session)rootNode.getDataAfter();
                    if (created == null || rootNode.getDataBefore() != null) continue block4;
                    this.publishStartedSession((DataObject)created);
                    continue block4;
                }
                case DELETE: {
                    Session removed = (Session)rootNode.getDataBefore();
                    if (removed == null) continue block4;
                    this.publishEndedSession((DataObject)removed);
                    continue block4;
                }
            }
            LOG.debug("Received intentionally unhandled type: {}.", (Object)modificationType);
        }
    }

    private void publishStartedSession(DataObject dataObject) {
        Preconditions.checkArgument((boolean)(dataObject instanceof Session));
        Session session = (Session)dataObject;
        NetconfSessionStart sessionStart = new NetconfSessionStartBuilder().setSessionId(new SessionIdOrZeroType(session.getSessionId())).setSourceHost(session.getSourceHost().getIpAddress()).setUsername(session.getUsername()).build();
        this.baseNotificationPublisherRegistration.onSessionStarted(sessionStart);
    }

    private void publishEndedSession(DataObject dataObject) {
        Preconditions.checkArgument((boolean)(dataObject instanceof Session));
        Session session = (Session)dataObject;
        NetconfSessionEnd sessionEnd = new NetconfSessionEndBuilder().setSessionId(new SessionIdOrZeroType(session.getSessionId())).setSourceHost(session.getSourceHost().getIpAddress()).setUsername(session.getUsername()).build();
        this.baseNotificationPublisherRegistration.onSessionEnded(sessionEnd);
    }

    public void close() {
        if (this.baseNotificationPublisherRegistration != null) {
            this.baseNotificationPublisherRegistration.close();
        }
        if (this.sessionListenerRegistration != null) {
            this.sessionListenerRegistration.close();
        }
    }
}

