/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.notification.impl.ops;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import javassist.ClassPool;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMResult;
import org.opendaylight.mdsal.binding.dom.codec.gen.impl.StreamWriterGenerator;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingNormalizedNodeCodecRegistry;
import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.impl.ModuleInfoBackedContext;
import org.opendaylight.mdsal.binding.generator.util.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.generator.util.JavassistUtils;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.notifications.NetconfNotification;
import org.opendaylight.netconf.util.NetconfUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.w3c.dom.Document;

public final class NotificationsTransformUtil {
    static final SchemaContext NOTIFICATIONS_SCHEMA_CTX;
    static final BindingNormalizedNodeCodecRegistry CODEC_REGISTRY;
    static final RpcDefinition CREATE_SUBSCRIPTION_RPC;

    private NotificationsTransformUtil() {
    }

    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"}, justification="Unrecognised NullableDecl")
    private static RpcDefinition findCreateSubscriptionRpc() {
        return (RpcDefinition)Iterables.getFirst((Iterable)Collections2.filter((Collection)NOTIFICATIONS_SCHEMA_CTX.getOperations(), input -> input.getQName().getLocalName().equals("create-subscription")), null);
    }

    public static NetconfNotification transform(Notification notification, SchemaPath path) {
        return NotificationsTransformUtil.transform(notification, Optional.empty(), path);
    }

    public static NetconfNotification transform(Notification notification, Date eventTime, SchemaPath path) {
        return NotificationsTransformUtil.transform(notification, Optional.ofNullable(eventTime), path);
    }

    private static NetconfNotification transform(Notification notification, Optional<Date> eventTime, SchemaPath path) {
        ContainerNode containerNode = CODEC_REGISTRY.toNormalizedNodeNotification(notification);
        DOMResult result = new DOMResult(XmlUtil.newDocument());
        try {
            NetconfUtil.writeNormalizedNode((NormalizedNode)containerNode, (DOMResult)result, (SchemaPath)path, (SchemaContext)NOTIFICATIONS_SCHEMA_CTX);
        }
        catch (IOException | XMLStreamException e) {
            throw new IllegalStateException("Unable to serialize " + notification, e);
        }
        Document node = (Document)result.getNode();
        return eventTime.isPresent() ? new NetconfNotification(node, eventTime.get()) : new NetconfNotification(node);
    }

    static {
        ModuleInfoBackedContext moduleInfoBackedContext = ModuleInfoBackedContext.create();
        moduleInfoBackedContext.addModuleInfos(Collections.singletonList(.YangModuleInfoImpl.getInstance()));
        moduleInfoBackedContext.addModuleInfos(Collections.singletonList(.YangModuleInfoImpl.getInstance()));
        Optional schemaContextOptional = moduleInfoBackedContext.tryToCreateSchemaContext();
        Preconditions.checkState((boolean)schemaContextOptional.isPresent());
        NOTIFICATIONS_SCHEMA_CTX = (SchemaContext)schemaContextOptional.get();
        CREATE_SUBSCRIPTION_RPC = (RpcDefinition)Preconditions.checkNotNull((Object)NotificationsTransformUtil.findCreateSubscriptionRpc());
        Preconditions.checkNotNull((Object)CREATE_SUBSCRIPTION_RPC);
        JavassistUtils javassist = JavassistUtils.forClassPool((ClassPool)ClassPool.getDefault());
        CODEC_REGISTRY = new BindingNormalizedNodeCodecRegistry(StreamWriterGenerator.create((JavassistUtils)javassist));
        CODEC_REGISTRY.onBindingRuntimeContextUpdated(BindingRuntimeContext.create((ClassLoadingStrategy)moduleInfoBackedContext, (SchemaContext)NOTIFICATIONS_SCHEMA_CTX));
    }
}

