/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.compat;

import org.opendaylight.controller.md.sal.binding.impl.LazySerializedDOMNotification;
import org.opendaylight.controller.md.sal.dom.api.DOMNotification;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationListener;
import org.opendaylight.controller.sal.binding.api.NotificationListener;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yangtools.yang.binding.Notification;

final class FunctionalNotificationListenerAdapter<N extends Notification>
implements DOMNotificationListener {
    private final BindingNormalizedNodeSerializer codec;
    private final NotificationListener<N> delegate;
    private final Class<N> type;

    FunctionalNotificationListenerAdapter(BindingNormalizedNodeSerializer codec, Class<N> type, NotificationListener<N> delegate) {
        this.codec = codec;
        this.type = type;
        this.delegate = delegate;
    }

    public void onNotification(DOMNotification notification) {
        this.delegate.onNotification((Notification)this.type.cast(this.deserialize(notification)));
    }

    private Notification deserialize(DOMNotification notification) {
        if (notification instanceof LazySerializedDOMNotification) {
            return ((LazySerializedDOMNotification)notification).getBindingData();
        }
        return this.codec.fromNormalizedNodeNotification(notification.getType(), notification.getBody());
    }
}

