/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.codec.DeserializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractForwardedDataBroker
implements Delegator<DOMDataBroker>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractForwardedDataBroker.class);
    private final DOMDataBroker domDataBroker;
    private final BindingToNormalizedNodeCodec codec;

    protected AbstractForwardedDataBroker(DOMDataBroker domDataBroker, BindingToNormalizedNodeCodec codec, DOMSchemaService schemaService) {
        this.domDataBroker = domDataBroker;
        this.codec = codec;
    }

    protected AbstractForwardedDataBroker(DOMDataBroker domDataBroker, BindingToNormalizedNodeCodec codec) {
        this.domDataBroker = domDataBroker;
        this.codec = codec;
    }

    protected BindingToNormalizedNodeCodec getCodec() {
        return this.codec;
    }

    public DOMDataBroker getDelegate() {
        return this.domDataBroker;
    }

    protected Map<InstanceIdentifier<?>, DataObject> toBinding(InstanceIdentifier<?> path, Map<YangInstanceIdentifier, ? extends NormalizedNode<?, ?>> normalized) {
        HashMap newMap = new HashMap();
        for (Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> entry : normalized.entrySet()) {
            try {
                Optional potential = this.getCodec().toBinding(entry);
                if (!potential.isPresent()) continue;
                Map.Entry binding = (Map.Entry)potential.get();
                newMap.put((InstanceIdentifier<?>)binding.getKey(), (DataObject)binding.getValue());
            }
            catch (DeserializationException e) {
                LOG.warn("Failed to transform {}, omitting it", entry, (Object)e);
            }
        }
        return newMap;
    }

    protected Set<InstanceIdentifier<?>> toBinding(InstanceIdentifier<?> path, Set<YangInstanceIdentifier> normalized) {
        HashSet hashSet = new HashSet();
        for (YangInstanceIdentifier normalizedPath : normalized) {
            try {
                Optional potential = this.getCodec().toBinding(normalizedPath);
                if (potential.isPresent()) {
                    InstanceIdentifier binding = (InstanceIdentifier)potential.get();
                    hashSet.add(binding);
                    continue;
                }
                if (!(normalizedPath.getLastPathArgument() instanceof YangInstanceIdentifier.AugmentationIdentifier)) continue;
                hashSet.add(path);
            }
            catch (DeserializationException e) {
                LOG.warn("Failed to transform {}, omitting it", (Object)normalizedPath, (Object)e);
            }
        }
        return hashSet;
    }

    protected Optional<DataObject> toBindingData(InstanceIdentifier<?> path, NormalizedNode<?, ?> data) {
        if (path.isWildcarded()) {
            return Optional.empty();
        }
        return (Optional)this.getCodec().deserializeFunction(path).apply(Optional.of(data));
    }

    @Override
    public void close() {
    }
}

