/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.common.api.MappingCheckedFuture;
import org.opendaylight.controller.md.sal.common.api.data.AsyncTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadTransaction;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

abstract class AbstractForwardedTransaction<T extends AsyncTransaction<YangInstanceIdentifier, NormalizedNode<?, ?>>>
implements Delegator<T>,
Identifiable<Object> {
    private final T delegate;
    private final BindingToNormalizedNodeCodec codec;

    AbstractForwardedTransaction(T delegateTx, BindingToNormalizedNodeCodec codec) {
        this.delegate = (AsyncTransaction)Preconditions.checkNotNull(delegateTx, (Object)"Delegate must not be null");
        this.codec = (BindingToNormalizedNodeCodec)((Object)Preconditions.checkNotNull((Object)((Object)codec), (Object)"Codec must not be null"));
    }

    public final Object getIdentifier() {
        return this.delegate.getIdentifier();
    }

    public final T getDelegate() {
        return this.delegate;
    }

    protected final <S extends AsyncTransaction<YangInstanceIdentifier, NormalizedNode<?, ?>>> S getDelegateChecked(Class<S> txType) {
        Preconditions.checkState((boolean)txType.isInstance(this.delegate));
        return (S)this.delegate;
    }

    protected final BindingToNormalizedNodeCodec getCodec() {
        return this.codec;
    }

    protected final <D extends DataObject> CheckedFuture<com.google.common.base.Optional<D>, ReadFailedException> doRead(DOMDataReadTransaction readTx, LogicalDatastoreType store, InstanceIdentifier<D> path) {
        Preconditions.checkArgument((!path.isWildcarded() ? 1 : 0) != 0, (String)"Invalid read of wildcarded path %s", path);
        return MappingCheckedFuture.create((ListenableFuture)Futures.transform((ListenableFuture)readTx.read(store, this.codec.toYangInstanceIdentifierBlocking(path)), result -> com.google.common.base.Optional.fromJavaUtil((Optional)((Optional)this.codec.deserializeFunction(path).apply(result.toJavaUtil()))), (Executor)MoreExecutors.directExecutor()), (Function)ReadFailedException.MAPPER);
    }

    protected final CheckedFuture<Boolean, ReadFailedException> doExists(DOMDataReadTransaction readTx, LogicalDatastoreType store, InstanceIdentifier<?> path) {
        Preconditions.checkArgument((!path.isWildcarded() ? 1 : 0) != 0, (String)"Invalid read of wildcarded path %s", path);
        return MappingCheckedFuture.create((ListenableFuture)readTx.exists(store, this.codec.toYangInstanceIdentifierBlocking(path)), (Function)ReadFailedException.MAPPER);
    }
}

