/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.Preconditions;
import org.opendaylight.controller.md.sal.binding.api.ClusteredDataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataTreeChangeService;
import org.opendaylight.controller.md.sal.binding.api.DataTreeIdentifier;
import org.opendaylight.controller.md.sal.binding.impl.BindingClusteredDOMDataTreeChangeListenerAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMDataTreeChangeListenerAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDataTreeChangeListenerRegistration;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeService;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

final class BindingDOMDataTreeChangeServiceAdapter
implements DataTreeChangeService {
    private final BindingToNormalizedNodeCodec codec;
    private final DOMDataTreeChangeService dataTreeChangeService;

    private BindingDOMDataTreeChangeServiceAdapter(BindingToNormalizedNodeCodec codec, DOMDataTreeChangeService dataTreeChangeService) {
        this.codec = (BindingToNormalizedNodeCodec)((Object)Preconditions.checkNotNull((Object)((Object)codec)));
        this.dataTreeChangeService = (DOMDataTreeChangeService)Preconditions.checkNotNull((Object)dataTreeChangeService);
    }

    static DataTreeChangeService create(BindingToNormalizedNodeCodec codec, DOMDataTreeChangeService dataTreeChangeService) {
        return new BindingDOMDataTreeChangeServiceAdapter(codec, dataTreeChangeService);
    }

    public <T extends DataObject, L extends DataTreeChangeListener<T>> ListenerRegistration<L> registerDataTreeChangeListener(DataTreeIdentifier<T> treeId, L listener) {
        DOMDataTreeIdentifier domIdentifier = this.toDomTreeIdentifier(treeId);
        BindingDOMDataTreeChangeListenerAdapter domListener = listener instanceof ClusteredDataTreeChangeListener ? new BindingClusteredDOMDataTreeChangeListenerAdapter(this.codec, (ClusteredDataTreeChangeListener)listener, treeId.getDatastoreType()) : new BindingDOMDataTreeChangeListenerAdapter(this.codec, listener, treeId.getDatastoreType());
        ListenerRegistration domReg = this.dataTreeChangeService.registerDataTreeChangeListener(domIdentifier, domListener);
        return new BindingDataTreeChangeListenerRegistration<L>(listener, domReg);
    }

    private DOMDataTreeIdentifier toDomTreeIdentifier(DataTreeIdentifier<?> treeId) {
        YangInstanceIdentifier domPath = this.codec.toYangInstanceIdentifierBlocking((InstanceIdentifier<? extends DataObject>)treeId.getRootIdentifier());
        return new DOMDataTreeIdentifier(treeId.getDatastoreType(), domPath);
    }
}

