/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.opendaylight.controller.md.sal.binding.api.MountPoint;
import org.opendaylight.controller.md.sal.binding.api.MountPointService;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMMountPointListenerAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingMountPointAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPoint;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPointService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingDOMMountPointServiceAdapter
implements MountPointService {
    private static final Logger LOG = LoggerFactory.getLogger(BindingDOMMountPointServiceAdapter.class);
    private final BindingToNormalizedNodeCodec codec;
    private final DOMMountPointService mountService;
    @VisibleForTesting
    final LoadingCache<DOMMountPoint, BindingMountPointAdapter> bindingMountpoints = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new CacheLoader<DOMMountPoint, BindingMountPointAdapter>(){

        public BindingMountPointAdapter load(DOMMountPoint key) {
            return new BindingMountPointAdapter(BindingDOMMountPointServiceAdapter.this.codec, key);
        }
    });

    public BindingDOMMountPointServiceAdapter(DOMMountPointService mountService, BindingToNormalizedNodeCodec codec) {
        this.codec = codec;
        this.mountService = mountService;
    }

    public Optional<MountPoint> getMountPoint(InstanceIdentifier<?> mountPoint) {
        YangInstanceIdentifier domPath = this.codec.toYangInstanceIdentifierBlocking(mountPoint);
        Optional domMount = this.mountService.getMountPoint(domPath);
        if (domMount.isPresent()) {
            return Optional.fromNullable((Object)this.bindingMountpoints.getUnchecked(domMount.get()));
        }
        return Optional.absent();
    }

    public <T extends MountPointService.MountPointListener> ListenerRegistration<T> registerListener(InstanceIdentifier<?> path, T listener) {
        return new BindingDOMMountPointListenerAdapter<T>(listener, this.codec, this.mountService);
    }
}

