/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.opendaylight.controller.md.sal.binding.impl.LazyDOMRpcResultFuture;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcException;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcIdentifier;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementation;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDataAware;
import org.opendaylight.mdsal.binding.dom.adapter.invoke.RpcServiceInvoker;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public class BindingDOMRpcImplementationAdapter
implements DOMRpcImplementation {
    private static final Cache<Class<?>, RpcServiceInvoker> SERVICE_INVOKERS = CacheBuilder.newBuilder().weakKeys().build();
    private final BindingNormalizedNodeSerializer codec;
    private final RpcServiceInvoker invoker;
    private final RpcService delegate;
    private final QName inputQname;

    <T extends RpcService> BindingDOMRpcImplementationAdapter(BindingNormalizedNodeSerializer codec, Class<T> type, Map<SchemaPath, Method> localNameToMethod, T delegate) {
        try {
            this.invoker = (RpcServiceInvoker)SERVICE_INVOKERS.get(type, () -> {
                HashMap map = new HashMap();
                for (Map.Entry e : localNameToMethod.entrySet()) {
                    map.put(((SchemaPath)e.getKey()).getLastComponent(), e.getValue());
                }
                return RpcServiceInvoker.from(map);
            });
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException("Failed to create invokers for type " + type, e);
        }
        this.codec = Objects.requireNonNull(codec);
        this.delegate = Objects.requireNonNull(delegate);
        this.inputQname = QName.create((QNameModule)BindingReflections.getQNameModule(type), (String)"input").intern();
    }

    public CheckedFuture<DOMRpcResult, DOMRpcException> invokeRpc(DOMRpcIdentifier rpc, NormalizedNode<?, ?> input) {
        SchemaPath schemaPath = rpc.getType();
        DataObject bindingInput = input != null ? this.deserialize(rpc.getType(), input) : null;
        ListenableFuture<RpcResult<?>> bindingResult = this.invoke(schemaPath, bindingInput);
        return this.transformResult(bindingResult);
    }

    private DataObject deserialize(SchemaPath rpcPath, NormalizedNode<?, ?> input) {
        if (input instanceof BindingDataAware) {
            return ((BindingDataAware)input).bindingData();
        }
        SchemaPath inputSchemaPath = rpcPath.createChild(this.inputQname);
        return this.codec.fromNormalizedNodeRpcData(inputSchemaPath, (ContainerNode)input);
    }

    private ListenableFuture<RpcResult<?>> invoke(SchemaPath schemaPath, DataObject input) {
        return this.invoker.invokeRpc(this.delegate, schemaPath.getLastComponent(), input);
    }

    private CheckedFuture<DOMRpcResult, DOMRpcException> transformResult(ListenableFuture<RpcResult<?>> bindingResult) {
        return LazyDOMRpcResultFuture.create(this.codec, bindingResult);
    }
}

