/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Method;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.md.sal.binding.impl.DirectGetterRouteContextExtractor;
import org.opendaylight.controller.md.sal.binding.impl.GetValueRouteContextExtractor;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.annotations.RoutingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ContextReferenceExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(ContextReferenceExtractor.class);
    private static final ContextReferenceExtractor NULL_EXTRACTOR = new ContextReferenceExtractor(){

        @Override
        InstanceIdentifier<?> extract(DataObject obj) {
            return null;
        }
    };
    private static final LoadingCache<Class<?>, ContextReferenceExtractor> EXTRACTORS = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, ContextReferenceExtractor>(){

        public ContextReferenceExtractor load(Class<?> key) {
            return ContextReferenceExtractor.create(key);
        }
    });
    private static final String GET_VALUE_NAME = "getValue";

    ContextReferenceExtractor() {
    }

    static ContextReferenceExtractor from(Class<?> obj) {
        return (ContextReferenceExtractor)EXTRACTORS.getUnchecked(obj);
    }

    abstract @Nullable InstanceIdentifier<?> extract(DataObject var1);

    private static @NonNull ContextReferenceExtractor create(Class<?> key) {
        Method contextGetter = ContextReferenceExtractor.getContextGetter(key);
        if (contextGetter == null) {
            return NULL_EXTRACTOR;
        }
        Class<?> returnType = contextGetter.getReturnType();
        try {
            if (InstanceIdentifier.class.isAssignableFrom(returnType)) {
                return DirectGetterRouteContextExtractor.create(contextGetter);
            }
            Method getValueMethod = ContextReferenceExtractor.findGetValueMethod(returnType, InstanceIdentifier.class);
            if (getValueMethod != null) {
                return GetValueRouteContextExtractor.create(contextGetter, getValueMethod);
            }
            LOG.warn("Class {} can not be used to determine context, falling back to NULL_EXTRACTOR.", returnType);
        }
        catch (IllegalAccessException e) {
            LOG.warn("Class {} does not conform to Binding Specification v1. Falling back to NULL_EXTRACTOR", (Throwable)e);
        }
        return NULL_EXTRACTOR;
    }

    private static @Nullable Method findGetValueMethod(Class<?> type, Class<?> returnType) {
        try {
            Method method = type.getMethod(GET_VALUE_NAME, new Class[0]);
            if (returnType.equals(method.getReturnType())) {
                return method;
            }
        }
        catch (NoSuchMethodException e) {
            LOG.warn("Value class {} does not comform to Binding Specification v1.", type, (Object)e);
        }
        return null;
    }

    private static Method getContextGetter(Class<?> key) {
        for (Method method : key.getMethods()) {
            if (method.getAnnotation(RoutingContext.class) == null) continue;
            return method;
        }
        return null;
    }
}

