/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.spi.scan;

import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ops4j.pax.cdi.spi.BeanBundles;
import org.ops4j.pax.cdi.spi.scan.BeanDescriptor;
import org.ops4j.pax.cdi.spi.scan.BeanDescriptorParser;
import org.ops4j.pax.cdi.spi.scan.BeanDiscoveryMode;
import org.ops4j.pax.cdi.spi.scan.BundleFilter;
import org.ops4j.pax.cdi.spi.scan.DefaultBeanDescriptor;
import org.osgi.framework.Bundle;

public class BeanBundleFilter
implements BundleFilter {
    private BeanDescriptorParser parser;
    private Map<Bundle, BeanDescriptor> descriptorMap;

    public BeanBundleFilter(BeanDescriptorParser parser) {
        this.parser = parser;
        this.descriptorMap = new HashMap<Bundle, BeanDescriptor>();
    }

    @Override
    public boolean accept(Bundle providerBundle, String className) {
        BeanDescriptor descriptor = this.findDescriptor(providerBundle);
        switch (descriptor.getBeanDiscoveryMode()) {
            case ALL: 
            case ANNOTATED: {
                return true;
            }
            case NONE: {
                return false;
            }
        }
        throw new IllegalArgumentException(descriptor.getBeanDiscoveryMode().toString());
    }

    public BeanDescriptor findDescriptor(Bundle providerBundle) {
        BeanDescriptor descriptor = this.descriptorMap.get(providerBundle);
        if (descriptor == null) {
            descriptor = this.loadDescriptor(providerBundle);
            this.descriptorMap.put(providerBundle, descriptor);
        }
        return descriptor;
    }

    private BeanDescriptor loadDescriptor(Bundle bundle) {
        URL beansXml = null;
        if (this.isWebBundle(bundle)) {
            beansXml = bundle.getEntry("WEB-INF/beans.xml");
            if (beansXml == null) {
                beansXml = bundle.getEntry("WEB-INF/classes/META-INF/beans.xml");
            }
        } else {
            beansXml = bundle.getEntry("META-INF/beans.xml");
        }
        if (beansXml == null) {
            if (BeanBundles.isBeanBundle(bundle)) {
                return new DefaultBeanDescriptor(bundle.getEntry("/"));
            }
            return new DefaultBeanDescriptor(bundle.getEntry("/"), BeanDiscoveryMode.NONE, "1.1");
        }
        return this.parser.parse(beansXml);
    }

    private boolean isWebBundle(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String contextPath = (String)headers.get("Web-ContextPath");
        return contextPath != null;
    }

    public List<URL> getBeanDescriptors() {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (BeanDescriptor descriptor : this.descriptorMap.values()) {
            urls.add(descriptor.getUrl());
        }
        return urls;
    }
}

