/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.ssh;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.io.IoInputStream;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.command.AsyncCommand;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.session.ServerSession;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.ssh.SshProxyClientHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteNetconfCommand
implements AsyncCommand,
SessionAware {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteNetconfCommand.class);
    private final EventLoopGroup clientEventGroup;
    private final LocalAddress localAddress;
    private IoInputStream in;
    private IoOutputStream out;
    private ExitCallback callback;
    private NetconfHelloMessageAdditionalHeader netconfHelloMessageAdditionalHeader;
    private Channel clientChannel;
    private ChannelFuture clientChannelFuture;

    public RemoteNetconfCommand(EventLoopGroup clientEventGroup, LocalAddress localAddress) {
        this.clientEventGroup = clientEventGroup;
        this.localAddress = localAddress;
    }

    public void setIoInputStream(IoInputStream in) {
        this.in = in;
    }

    public void setIoOutputStream(IoOutputStream out) {
        this.out = out;
    }

    public void setIoErrorStream(IoOutputStream err) {
    }

    public void setInputStream(InputStream in) {
        throw new UnsupportedOperationException("Synchronous IO is unsupported");
    }

    public void setOutputStream(OutputStream out) {
        throw new UnsupportedOperationException("Synchronous IO is unsupported");
    }

    public void setErrorStream(OutputStream err) {
        throw new UnsupportedOperationException("Synchronous IO is unsupported");
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void start(Environment env) {
        LOG.trace("Establishing internal connection to netconf server for client: {}", (Object)this.getClientAddress());
        Bootstrap clientBootstrap = new Bootstrap();
        ((Bootstrap)clientBootstrap.group(this.clientEventGroup)).channel(LocalChannel.class);
        clientBootstrap.handler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new SshProxyClientHandler(RemoteNetconfCommand.this.in, RemoteNetconfCommand.this.out, RemoteNetconfCommand.this.netconfHelloMessageAdditionalHeader, RemoteNetconfCommand.this.callback)});
            }
        });
        this.clientChannelFuture = clientBootstrap.connect((SocketAddress)this.localAddress);
        this.clientChannelFuture.addListener(future -> {
            if (future.isSuccess()) {
                this.clientChannel = this.clientChannelFuture.channel();
            } else {
                LOG.warn("Unable to establish internal connection to netconf server for client: {}", (Object)this.getClientAddress());
                Preconditions.checkNotNull((Object)this.callback, (Object)"Exit callback must be set");
                this.callback.onExit(1, "Unable to establish internal connection to netconf server for client: " + this.getClientAddress());
            }
        });
    }

    public void destroy() {
        LOG.trace("Releasing internal connection to netconf server for client: {} on channel: {}", (Object)this.getClientAddress(), (Object)this.clientChannel);
        this.clientChannelFuture.cancel(true);
        if (this.clientChannel != null) {
            this.clientChannel.close().addListener(future -> {
                if (!future.isSuccess()) {
                    LOG.warn("Unable to release internal connection to netconf server on channel: {}", (Object)this.clientChannel);
                }
            });
        }
    }

    private String getClientAddress() {
        return this.netconfHelloMessageAdditionalHeader.getAddress();
    }

    public void setSession(ServerSession session) {
        SocketAddress remoteAddress = session.getIoSession().getRemoteAddress();
        String hostName = "";
        String port = "";
        if (remoteAddress instanceof InetSocketAddress) {
            hostName = ((InetSocketAddress)remoteAddress).getAddress().getHostAddress();
            port = Integer.toString(((InetSocketAddress)remoteAddress).getPort());
        }
        this.netconfHelloMessageAdditionalHeader = new NetconfHelloMessageAdditionalHeader(session.getUsername(), hostName, port, "ssh", "client");
    }

    public static class NetconfCommandFactory
    implements NamedFactory<Command> {
        public static final String NETCONF = "netconf";
        private final EventLoopGroup clientBootstrap;
        private final LocalAddress localAddress;

        public NetconfCommandFactory(EventLoopGroup clientBootstrap, LocalAddress localAddress) {
            this.clientBootstrap = clientBootstrap;
            this.localAddress = localAddress;
        }

        public String getName() {
            return NETCONF;
        }

        public RemoteNetconfCommand create() {
            return new RemoteNetconfCommand(this.clientBootstrap, this.localAddress);
        }
    }
}

