/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.ssh;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.nio.charset.StandardCharsets;
import org.apache.sshd.common.io.IoInputStream;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.server.ExitCallback;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.nettyutil.handler.ssh.client.AsyncSshHandlerReader;
import org.opendaylight.netconf.nettyutil.handler.ssh.client.AsyncSshHandlerWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SshProxyClientHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SshProxyClientHandler.class);
    private final IoInputStream in;
    private final IoOutputStream out;
    private AsyncSshHandlerReader asyncSshHandlerReader;
    private AsyncSshHandlerWriter asyncSshHandlerWriter;
    private final NetconfHelloMessageAdditionalHeader netconfHelloMessageAdditionalHeader;
    private final ExitCallback callback;

    SshProxyClientHandler(IoInputStream in, IoOutputStream out, NetconfHelloMessageAdditionalHeader netconfHelloMessageAdditionalHeader, ExitCallback callback) {
        this.in = in;
        this.out = out;
        this.netconfHelloMessageAdditionalHeader = netconfHelloMessageAdditionalHeader;
        this.callback = callback;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.writeAdditionalHeader(ctx);
        this.asyncSshHandlerWriter = new AsyncSshHandlerWriter(this.out);
        this.asyncSshHandlerReader = new AsyncSshHandlerReader(() -> {
            ctx.fireChannelInactive();
            ctx.disconnect();
            ctx.close();
            this.asyncSshHandlerReader.close();
            this.asyncSshHandlerWriter.close();
        }, msg -> {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Forwarding message for client: {} on channel: {}, message: {}", new Object[]{this.netconfHelloMessageAdditionalHeader.getAddress(), ctx.channel(), AsyncSshHandlerWriter.byteBufToString((ByteBuf)msg)});
            }
            ctx.writeAndFlush((Object)msg);
        }, "ssh" + this.netconfHelloMessageAdditionalHeader.getAddress(), this.in);
        super.channelActive(ctx);
    }

    private void writeAdditionalHeader(ChannelHandlerContext ctx) {
        ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])this.netconfHelloMessageAdditionalHeader.toFormattedString().getBytes(StandardCharsets.UTF_8)));
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.asyncSshHandlerWriter.write(ctx, msg, ctx.newPromise());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        LOG.debug("Internal connection to netconf server was dropped for client: {} on channel: {}", (Object)this.netconfHelloMessageAdditionalHeader.getAddress(), (Object)ctx.channel());
        this.callback.onExit(1, "Internal connection to netconf server was dropped for client: " + this.netconfHelloMessageAdditionalHeader.getAddress() + " on channel: " + ctx.channel());
        super.channelInactive(ctx);
    }
}

