/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.ssh;

import com.google.common.base.Preconditions;
import io.netty.channel.local.LocalAddress;
import java.net.InetSocketAddress;
import java.util.Optional;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.opendaylight.netconf.auth.AuthProvider;

public final class SshProxyServerConfiguration {
    private final InetSocketAddress bindingAddress;
    private final LocalAddress localAddress;
    private final AuthProvider authenticator;
    private final KeyPairProvider keyPairProvider;
    private final int idleTimeout;
    private final Optional<PublickeyAuthenticator> publickeyAuthenticator;

    SshProxyServerConfiguration(InetSocketAddress bindingAddress, LocalAddress localAddress, AuthProvider authenticator, PublickeyAuthenticator publickeyAuthenticator, KeyPairProvider keyPairProvider, int idleTimeout) {
        this.bindingAddress = (InetSocketAddress)Preconditions.checkNotNull((Object)bindingAddress);
        this.localAddress = (LocalAddress)Preconditions.checkNotNull((Object)localAddress);
        this.authenticator = (AuthProvider)Preconditions.checkNotNull((Object)authenticator);
        this.keyPairProvider = (KeyPairProvider)Preconditions.checkNotNull((Object)keyPairProvider);
        Preconditions.checkArgument((idleTimeout > 0 ? 1 : 0) != 0, (Object)"Idle timeout has to be > 0");
        this.idleTimeout = idleTimeout;
        this.publickeyAuthenticator = Optional.ofNullable(publickeyAuthenticator);
    }

    public InetSocketAddress getBindingAddress() {
        return this.bindingAddress;
    }

    public LocalAddress getLocalAddress() {
        return this.localAddress;
    }

    public AuthProvider getAuthenticator() {
        return this.authenticator;
    }

    public KeyPairProvider getKeyPairProvider() {
        return this.keyPairProvider;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public Optional<PublickeyAuthenticator> getPublickeyAuthenticator() {
        return this.publickeyAuthenticator;
    }
}

