/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.ssh;

import io.netty.channel.local.LocalAddress;
import java.net.InetSocketAddress;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.opendaylight.netconf.auth.AuthProvider;
import org.opendaylight.netconf.ssh.SshProxyServerConfiguration;

public final class SshProxyServerConfigurationBuilder {
    private InetSocketAddress bindingAddress;
    private LocalAddress localAddress;
    private AuthProvider authenticator;
    private KeyPairProvider keyPairProvider;
    private int idleTimeout;
    private PublickeyAuthenticator publickeyAuthenticator = null;

    public SshProxyServerConfigurationBuilder setBindingAddress(InetSocketAddress bindingAddress) {
        this.bindingAddress = bindingAddress;
        return this;
    }

    public SshProxyServerConfigurationBuilder setLocalAddress(LocalAddress localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    public SshProxyServerConfigurationBuilder setAuthenticator(AuthProvider authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    public SshProxyServerConfigurationBuilder setPublickeyAuthenticator(PublickeyAuthenticator publickeyAuthenticator) {
        this.publickeyAuthenticator = publickeyAuthenticator;
        return this;
    }

    public SshProxyServerConfigurationBuilder setKeyPairProvider(KeyPairProvider keyPairProvider) {
        this.keyPairProvider = keyPairProvider;
        return this;
    }

    public SshProxyServerConfigurationBuilder setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    public SshProxyServerConfiguration createSshProxyServerConfiguration() {
        return new SshProxyServerConfiguration(this.bindingAddress, this.localAddress, this.authenticator, this.publickeyAuthenticator, this.keyPairProvider, this.idleTimeout);
    }

    public static SshProxyServerConfigurationBuilder create() {
        return new SshProxyServerConfigurationBuilder();
    }
}

