/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.trace.cli;

import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opendaylight.controller.md.sal.trace.api.TracingDOMDataBroker;

@Service
@Command(scope="trace", name="transactions", description="Show all (still) open transactions; including stack trace of creator, if transaction-debug-context-enabled is true in mdsaltrace_config.xml")
public class PrintOpenTransactionsCommand
implements Action {
    @Argument(index=0, name="minOpenTransactions", required=false, multiValued=false, description="Minimum open number of transactions (leaks with fewer are suppressed)")
    Integer minOpenTransactions = 1;
    @Reference
    private List<TracingDOMDataBroker> tracingDOMDataBrokers;

    public Object execute() {
        boolean hasFound = false;
        for (TracingDOMDataBroker tracingDOMDataBroker : this.tracingDOMDataBrokers) {
            hasFound |= tracingDOMDataBroker.printOpenTransactions(System.out, this.minOpenTransactions.intValue());
        }
        if (hasFound) {
            System.out.println("Actually did find real leaks with more than " + this.minOpenTransactions + " open transactions");
        } else {
            System.out.println("Did not find any real leaks with more than " + this.minOpenTransactions + " open transactions");
        }
        return hasFound;
    }
}

