/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.messagebus.eventsources.netconf;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.controller.messagebus.spi.EventSourceRegistry;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMNotificationPublishService;
import org.opendaylight.netconf.messagebus.eventsources.netconf.NetconfEventSourceRegistration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.network.topology.topology.topology.types.TopologyNetconf;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfEventSourceManager
implements DataTreeChangeListener<Node>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfEventSourceManager.class);
    private static final TopologyKey NETCONF_TOPOLOGY_KEY = new TopologyKey(new TopologyId(TopologyNetconf.QNAME.getLocalName()));
    private static final InstanceIdentifier<Node> NETCONF_DEVICE_PATH = InstanceIdentifier.create(NetworkTopology.class).child(Topology.class, (Identifier)NETCONF_TOPOLOGY_KEY).child(Node.class);
    private Map<String, String> streamMap;
    private final ConcurrentHashMap<InstanceIdentifier<?>, NetconfEventSourceRegistration> registrationMap = new ConcurrentHashMap();
    private final DOMNotificationPublishService publishService;
    private final DOMMountPointService domMounts;
    private ListenerRegistration<NetconfEventSourceManager> listenerRegistration;
    private final EventSourceRegistry eventSourceRegistry;
    private final DataBroker dataBroker;

    public NetconfEventSourceManager(DataBroker dataBroker, DOMNotificationPublishService domPublish, DOMMountPointService domMount, EventSourceRegistry eventSourceRegistry) {
        Preconditions.checkNotNull((Object)dataBroker);
        Preconditions.checkNotNull((Object)domPublish);
        Preconditions.checkNotNull((Object)domMount);
        Preconditions.checkNotNull((Object)eventSourceRegistry);
        this.dataBroker = dataBroker;
        this.domMounts = domMount;
        this.publishService = domPublish;
        this.eventSourceRegistry = eventSourceRegistry;
    }

    public void initialize() {
        Preconditions.checkNotNull((Object)this.dataBroker);
        this.listenerRegistration = this.dataBroker.registerDataTreeChangeListener(DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, NETCONF_DEVICE_PATH), (DataTreeChangeListener)this);
        LOG.info("NetconfEventSourceManager initialized.");
    }

    public void onDataTreeChanged(Collection<DataTreeModification<Node>> changes) {
        for (DataTreeModification<Node> change : changes) {
            LOG.debug("DataTreeModification: {}", change);
            DataObjectModification rootNode = change.getRootNode();
            InstanceIdentifier identifier = change.getRootPath().getRootIdentifier();
            switch (rootNode.getModificationType()) {
                case WRITE: 
                case SUBTREE_MODIFIED: {
                    this.nodeCreated(identifier, (Node)rootNode.getDataAfter());
                    break;
                }
                case DELETE: {
                    this.nodeRemoved(identifier);
                    break;
                }
            }
        }
    }

    private void nodeCreated(InstanceIdentifier<?> key, Node node) {
        NetconfEventSourceRegistration nesrOld;
        Preconditions.checkNotNull(key);
        if (!NetconfEventSourceManager.validateNode(node)) {
            LOG.warn("NodeCreated event : Node [{}] is null or not valid.", (Object)key.toString());
            return;
        }
        LOG.info("Netconf event source [{}] is creating...", (Object)key.toString());
        NetconfEventSourceRegistration nesr = NetconfEventSourceRegistration.create(key, node, this);
        if (nesr != null && (nesrOld = this.registrationMap.put(key, nesr)) != null) {
            nesrOld.close();
        }
    }

    private void nodeRemoved(InstanceIdentifier<?> key) {
        Preconditions.checkNotNull(key);
        LOG.info("Netconf event source [{}] is removing...", (Object)key.toString());
        NetconfEventSourceRegistration nesr = this.registrationMap.remove(key);
        if (nesr != null) {
            nesr.close();
        }
    }

    private static boolean validateNode(Node node) {
        return node == null ? false : NetconfEventSourceManager.isNetconfNode(node);
    }

    Map<String, String> getStreamMap() {
        return this.streamMap;
    }

    DOMNotificationPublishService getPublishService() {
        return this.publishService;
    }

    DOMMountPointService getDomMounts() {
        return this.domMounts;
    }

    EventSourceRegistry getEventSourceRegistry() {
        return this.eventSourceRegistry;
    }

    public void setStreamMap(Map<String, String> streamMap) {
        this.streamMap = streamMap;
    }

    private static boolean isNetconfNode(Node node) {
        return node.augmentation(NetconfNode.class) != null;
    }

    @Override
    public void close() {
        this.listenerRegistration.close();
        for (NetconfEventSourceRegistration reg : this.registrationMap.values()) {
            reg.close();
        }
        this.registrationMap.clear();
    }
}

