/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.messagebus.eventsources.netconf;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javassist.ClassPool;
import org.opendaylight.mdsal.binding.dom.codec.gen.impl.StreamWriterGenerator;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingNormalizedNodeCodecRegistry;
import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.impl.ModuleInfoBackedContext;
import org.opendaylight.mdsal.binding.generator.util.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.generator.util.JavassistUtils;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.CreateSubscriptionInput;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.CreateSubscriptionInputBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.Netconf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.Streams;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.Stream;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

class NetconfEventSourceMount {
    private static final BindingNormalizedNodeCodecRegistry CODEC_REGISTRY;
    private static final YangInstanceIdentifier STREAMS_PATH;
    private static final SchemaPath CREATE_SUBSCRIPTION;
    private final DOMMountPoint mountPoint;
    private final DOMRpcService rpcService;
    private final DOMNotificationService notificationService;
    private final DOMDataBroker dataBroker;
    private final Node node;
    private final String nodeId;

    NetconfEventSourceMount(Node node, DOMMountPoint mountPoint) {
        this.mountPoint = mountPoint;
        this.node = node;
        this.nodeId = node.getNodeId().getValue();
        this.rpcService = NetconfEventSourceMount.getService(mountPoint, DOMRpcService.class);
        this.notificationService = NetconfEventSourceMount.getService(mountPoint, DOMNotificationService.class);
        this.dataBroker = NetconfEventSourceMount.getService(mountPoint, DOMDataBroker.class);
    }

    private static <T extends DOMService> T getService(DOMMountPoint mountPoint, Class<T> service) {
        Optional optional = mountPoint.getService(service);
        Preconditions.checkState((boolean)optional.isPresent(), (String)"Service not present on mount point: %s", (Object)service.getName());
        return (T)((DOMService)optional.get());
    }

    Node getNode() {
        return this.node;
    }

    String getNodeId() {
        return this.nodeId;
    }

    FluentFuture<DOMRpcResult> invokeCreateSubscription(Stream stream, Optional<Instant> lastEventTime) {
        CreateSubscriptionInputBuilder inputBuilder = new CreateSubscriptionInputBuilder().setStream(stream.getName());
        if (lastEventTime.isPresent() && stream.isReplaySupport().booleanValue()) {
            ZonedDateTime dateTime = lastEventTime.get().atZone(ZoneId.systemDefault());
            String formattedDate = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(dateTime);
            inputBuilder.setStartTime(new DateAndTime(formattedDate));
        }
        CreateSubscriptionInput input = inputBuilder.build();
        ContainerNode nnInput = CODEC_REGISTRY.toNormalizedNodeRpcData((DataContainer)input);
        return this.rpcService.invokeRpc(CREATE_SUBSCRIPTION, (NormalizedNode)nnInput);
    }

    FluentFuture<DOMRpcResult> invokeCreateSubscription(Stream stream) {
        return this.invokeCreateSubscription(stream, Optional.empty());
    }

    List<Stream> getAvailableStreams() throws InterruptedException, ExecutionException {
        DOMDataTreeReadTransaction tx = this.dataBroker.newReadOnlyTransaction();
        FluentFuture checkFeature = tx.read(LogicalDatastoreType.OPERATIONAL, STREAMS_PATH);
        Optional streams = (Optional)checkFeature.get();
        if (streams.isPresent()) {
            Streams streams1 = (Streams)CODEC_REGISTRY.fromNormalizedNode(STREAMS_PATH, (NormalizedNode)streams.get()).getValue();
            return streams1.getStream();
        }
        return Collections.emptyList();
    }

    SchemaContext getSchemaContext() {
        return this.mountPoint.getSchemaContext();
    }

    ListenerRegistration<DOMNotificationListener> registerNotificationListener(DOMNotificationListener listener, SchemaPath notificationPath) {
        return this.notificationService.registerNotificationListener(listener, new SchemaPath[]{notificationPath});
    }

    static {
        STREAMS_PATH = YangInstanceIdentifier.builder().node(Netconf.QNAME).node(Streams.QNAME).build();
        CREATE_SUBSCRIPTION = SchemaPath.create((boolean)true, (QName[])new QName[]{QName.create((QName)CreateSubscriptionInput.QNAME, (String)"create-subscription")});
        ModuleInfoBackedContext moduleInfoBackedContext = ModuleInfoBackedContext.create();
        moduleInfoBackedContext.addModuleInfos(Collections.singletonList(.YangModuleInfoImpl.getInstance()));
        SchemaContext notificationsSchemaCtx = (SchemaContext)moduleInfoBackedContext.tryToCreateSchemaContext().get();
        JavassistUtils javassist = JavassistUtils.forClassPool((ClassPool)ClassPool.getDefault());
        CODEC_REGISTRY = new BindingNormalizedNodeCodecRegistry(StreamWriterGenerator.create((JavassistUtils)javassist));
        CODEC_REGISTRY.onBindingRuntimeContextUpdated(BindingRuntimeContext.create((ClassLoadingStrategy)moduleInfoBackedContext, (SchemaContext)notificationsSchemaCtx));
    }
}

