/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.docker;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.docker.Container;
import org.apache.karaf.docker.ContainerConfig;
import org.apache.karaf.docker.Image;
import org.apache.karaf.docker.ImageHistory;
import org.apache.karaf.docker.ImageSearch;
import org.apache.karaf.docker.Info;
import org.apache.karaf.docker.Top;
import org.apache.karaf.docker.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerClient.class);
    public static final String DEFAULT_URL = "http://localhost:2375";
    private String url;
    private ObjectMapper mapper;

    public DockerClient(String url) {
        this.url = url == null ? DEFAULT_URL : url;
        this.mapper = new ObjectMapper();
    }

    public Info info() throws Exception {
        URL dockerUrl = new URL(this.url + "/info");
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("GET");
        Info info = (Info)this.mapper.readValue(connection.getInputStream(), Info.class);
        return info;
    }

    public Version version() throws Exception {
        URL dockerUrl = new URL(this.url + "/version");
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("GET");
        Version version = (Version)this.mapper.readValue(connection.getInputStream(), Version.class);
        return version;
    }

    public List<Container> ps(boolean showAll) throws Exception {
        URL dockerUrl = new URL(this.url + "/containers/json?all=" + showAll);
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("GET");
        List containers = (List)this.mapper.readValue(connection.getInputStream(), (TypeReference)new TypeReference<List<Container>>(){});
        for (Container container : containers) {
            this.cleanName(container);
        }
        return containers;
    }

    private void cleanName(Container container) throws Exception {
        ArrayList<String> cleanNames = new ArrayList<String>();
        for (String name : container.getNames()) {
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            cleanNames.add(name);
        }
        container.setNames(cleanNames);
    }

    public Container inspect(String id) throws Exception {
        URL dockerUrl = new URL(this.url + "/containers/" + id + "/json?size=1");
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("GET");
        Container container = (Container)this.mapper.readValue(connection.getInputStream(), Container.class);
        return container;
    }

    public Top top(String id) throws Exception {
        URL dockerUrl = new URL(this.url + "/containers/" + id + "/top?ps_args=aux");
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("GET");
        Top top = (Top)this.mapper.readValue(connection.getInputStream(), Top.class);
        return top;
    }

    public void create(ContainerConfig config, String name) throws Exception {
        URL dockerUrl = new URL(this.url + "/containers/create?name=" + name);
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        this.mapper.writeValue(connection.getOutputStream(), (Object)config);
        if (connection.getResponseCode() != 201) {
            throw new IllegalStateException("Can't create Docker container " + name + ": " + connection.getResponseMessage());
        }
    }

    public void rm(String id, boolean removeVolumes, boolean force) throws Exception {
        URL dockerUrl = new URL(this.url + "/containers/" + id + "?v=" + removeVolumes + "&force=" + force);
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("DELETE");
        if (connection.getResponseCode() != 204) {
            throw new IllegalStateException("Can't remove Docker container " + id + ": " + connection.getResponseMessage());
        }
    }

    public void start(String id) throws Exception {
        URL dockerUrl = new URL(this.url + "/containers/" + id + "/start");
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("POST");
        if (connection.getResponseCode() != 204) {
            throw new IllegalStateException("Can't start Docker container " + id + ": " + connection.getResponseMessage());
        }
    }

    public void stop(String id, int timeToWait) throws Exception {
        URL dockerUrl = new URL(this.url + "/containers/" + id + "/stop?t=" + timeToWait);
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("POST");
        if (connection.getResponseCode() != 204) {
            throw new IllegalStateException("Can't stop Docker container " + id + ": " + connection.getResponseMessage());
        }
    }

    public void restart(String id, int timeToWait) throws Exception {
        URL dockerUrl = new URL(this.url + "/containers/" + id + "/restart?t=" + timeToWait);
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("POST");
        if (connection.getResponseCode() != 204) {
            throw new IllegalStateException("Can't restart Docker container " + id + ": " + connection.getResponseMessage());
        }
    }

    public void kill(String id, String signal) throws Exception {
        URL dockerUrl = new URL(this.url + "/containers/" + id + "/kill?signal=" + signal);
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("POST");
        if (connection.getResponseCode() != 204) {
            throw new IllegalStateException("Can't kill Docker container " + id + ": " + connection.getResponseMessage());
        }
    }

    public void rename(String id, String name) throws Exception {
        URL dockerUrl = new URL(this.url + "/containers/" + id + "/rename?name=" + name);
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("POST");
        if (connection.getResponseCode() != 204) {
            throw new IllegalStateException("Can't rename Docker container " + id + ": " + connection.getResponseMessage());
        }
    }

    public void pause(String id) throws Exception {
        URL dockerUrl = new URL(this.url + "/containers/" + id + "/pause");
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("POST");
        if (connection.getResponseCode() != 204) {
            throw new IllegalStateException("Can't pause Docker container " + id + ": " + connection.getResponseMessage());
        }
    }

    public void unpause(String id) throws Exception {
        URL dockerUrl = new URL(this.url + "/containers/" + id + "/unpause");
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("POST");
        if (connection.getResponseCode() != 204) {
            throw new IllegalStateException("Can't unpause Docker container " + id + ": " + connection.getResponseMessage());
        }
    }

    public String logs(String id, boolean stdout, boolean stderr, boolean timestamps, boolean details) throws Exception {
        String line;
        URL dockerUrl = new URL(this.url + "/containers/" + id + "/logs?stdout=" + stdout + "&stderr=" + stderr + "&timestamps=" + timestamps + "&details=" + details);
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("GET");
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        while ((line = reader.readLine()) != null) {
            buffer.append(line).append("\n");
        }
        return buffer.toString();
    }

    public void commit(String container, ContainerConfig config, String message, String repo, String tag) throws Exception {
        URL dockerUrl = new URL(this.url + "/commit?container=" + container + "&comment=" + message + "&repo=" + repo + "&tag=" + tag);
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        this.mapper.writeValue(connection.getOutputStream(), (Object)config);
        if (connection.getResponseCode() != 201) {
            throw new IllegalStateException("Can't commit Docker container " + container + ": " + connection.getResponseMessage());
        }
    }

    public List<Image> images(boolean showAll) throws Exception {
        URL dockerUrl = new URL(this.url + "/images/json?all=" + showAll);
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("GET");
        List images = (List)this.mapper.readValue(connection.getInputStream(), (TypeReference)new TypeReference<List<Image>>(){});
        return images;
    }

    public void pull(String name, String tag, boolean verbose) throws Exception {
        String line;
        URL dockerUrl = new URL(this.url + "/images/create?fromImage=" + name + "&tag=" + tag);
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("POST");
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        while ((line = reader.readLine()) != null) {
            LOGGER.debug(line);
            if (!verbose) continue;
            System.out.println(line);
        }
        if (connection.getResponseCode() != 200) {
            throw new IllegalStateException("Can't pull image " + name + ": " + connection.getResponseMessage());
        }
    }

    public void push(String name, String tag, boolean verbose) throws Exception {
        String line;
        URL dockerUrl = new URL(this.url + "/images/" + name + "/push?tag=" + tag);
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("POST");
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        while ((line = reader.readLine()) != null) {
            LOGGER.debug(line);
            if (!verbose) continue;
            System.out.println(line);
        }
        if (connection.getResponseCode() != 200) {
            throw new IllegalStateException("Can't push image " + name + ": " + connection.getResponseMessage());
        }
    }

    public void tag(String name, String repo, String tag) throws Exception {
        URL dockerUrl = new URL(this.url + "/images/" + name + "/tag?repo=" + repo + "&tag=" + tag);
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("POST");
        if (connection.getResponseCode() != 201) {
            throw new IllegalStateException("Can't tag image " + name + ": " + connection.getResponseMessage());
        }
    }

    public void rmi(String name, boolean force, boolean noprune) throws Exception {
        URL dockerUrl = new URL(this.url + "/images/" + name + "?force=" + force + "&noprune=" + noprune);
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("DELETE");
        if (connection.getResponseCode() != 200) {
            throw new IllegalStateException("Can't remove image " + name + ": " + connection.getResponseMessage());
        }
    }

    public List<ImageSearch> search(String term) throws Exception {
        URL dockerUrl = new URL(this.url + "/images/search?term=" + term);
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("GET");
        List images = (List)this.mapper.readValue(connection.getInputStream(), (TypeReference)new TypeReference<List<ImageSearch>>(){});
        return images;
    }

    public Image getImage(String name) throws Exception {
        URL dockerUrl = new URL(this.url + "/images/" + name + "/json");
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("GET");
        Image image = (Image)this.mapper.readValue(connection.getInputStream(), Image.class);
        return image;
    }

    public List<ImageHistory> history(String name) throws Exception {
        URL dockerUrl = new URL(this.url + "/images/" + name + "/history");
        HttpURLConnection connection = (HttpURLConnection)dockerUrl.openConnection();
        connection.setRequestMethod("GET");
        List images = (List)this.mapper.readValue(connection.getInputStream(), (TypeReference)new TypeReference<List<ImageHistory>>(){});
        return images;
    }
}

