/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.docker.command;

import java.util.List;
import org.apache.karaf.docker.ImageHistory;
import org.apache.karaf.docker.command.DockerCommandSupport;
import org.apache.karaf.docker.command.completers.ImagesRepoTagsCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="docker", name="history", description="Show the history of an image")
@Service
public class HistoryCommand
extends DockerCommandSupport {
    @Argument(index=0, name="image", description="Name or ID of the image", required=true, multiValued=false)
    @Completion(value=ImagesRepoTagsCompleter.class)
    String image;

    public Object execute() throws Exception {
        List<ImageHistory> histories = this.getDockerService().history(this.image, this.url);
        ShellTable table = new ShellTable();
        table.column("ID");
        table.column("Created");
        table.column("Created By");
        table.column("Tags");
        table.column("Size");
        for (ImageHistory history : histories) {
            table.addRow().addContent(new Object[]{history.getId(), history.getCreated(), history.getCreatedBy(), history.getComment(), history.getTags(), history.getSize()});
        }
        table.print(System.out);
        return null;
    }
}

