/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.docker.command;

import org.apache.karaf.docker.Image;
import org.apache.karaf.docker.command.DockerCommandSupport;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="docker", name="images", description="List Docker images")
@Service
public class ImagesCommand
extends DockerCommandSupport {
    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("Id");
        table.column("RepoTags");
        table.column("Created");
        table.column("Labels");
        table.column("Size");
        table.column("Virtual Size");
        for (Image image : this.getDockerService().images(this.url)) {
            table.addRow().addContent(new Object[]{image.getId(), image.getRepoTags(), image.getCreated(), image.getLabels(), image.getSize(), image.getVirtualSize()});
        }
        table.print(System.out);
        return null;
    }
}

