/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.docker.command;

import org.apache.karaf.docker.command.DockerCommandSupport;
import org.apache.karaf.docker.command.completers.ContainersNameCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="docker", name="logs", description="Fetch the logs of a container")
@Service
public class LogsCommand
extends DockerCommandSupport {
    @Argument(index=0, name="container", description="Name or ID of the container", required=true, multiValued=false)
    @Completion(value=ContainersNameCompleter.class)
    String container;
    @Option(name="--stdout", description="Display stdout", required=false, multiValued=false)
    boolean stdout = true;
    @Option(name="--stderr", description="Display stderr", required=false, multiValued=false)
    boolean stderr;
    @Option(name="--timestamps", description="Show timestamps", required=false, multiValued=false)
    boolean timestamps;
    @Option(name="--details", description="Show extra details provided to logs", required=false, multiValued=false)
    boolean details;

    public Object execute() throws Exception {
        if (!this.stdout && !this.stderr) {
            System.err.println("You have at least to choose one stream: stdout or stderr using the corresponding command options");
        }
        System.out.println(this.getDockerService().logs(this.container, this.stdout, this.stderr, this.timestamps, this.details, this.url));
        return null;
    }
}

