/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.docker.command;

import org.apache.karaf.docker.command.DockerCommandSupport;
import org.apache.karaf.docker.command.completers.ImagesRepoTagsCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="docker", name="push", description="Push an image or a repository to a registry")
@Service
public class PushCommand
extends DockerCommandSupport {
    @Argument(index=0, name="image", description="Name or ID of the image", required=true, multiValued=false)
    @Completion(value=ImagesRepoTagsCompleter.class)
    String image;
    @Option(name="--tag", description="Push tag", required=false, multiValued=false)
    String tag = "latest";
    @Option(name="-v", aliases={"--verbose"}, description="Display push progress on console", required=false, multiValued=false)
    boolean verbose;

    public Object execute() throws Exception {
        this.getDockerService().push(this.image, this.tag, this.verbose, this.url);
        return null;
    }
}

