/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.docker.command;

import java.util.List;
import org.apache.karaf.docker.command.DockerCommandSupport;
import org.apache.karaf.docker.command.completers.ContainersNameCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="docker", name="restart", description="Restart one or more containers")
@Service
public class RestartCommand
extends DockerCommandSupport {
    @Argument(index=0, name="container", description="Name or ID of the containers to restart", required=true, multiValued=true)
    @Completion(value=ContainersNameCompleter.class)
    List<String> containers;
    @Option(name="-t", aliases={"--time"}, description="Seconds to wait for stop before killing it (default 10)", required=false, multiValued=true)
    int timeToWait = 10;

    public Object execute() throws Exception {
        for (String container : this.containers) {
            this.getDockerService().restart(container, this.timeToWait, this.url);
        }
        return null;
    }
}

