/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.docker.command;

import org.apache.karaf.docker.ImageSearch;
import org.apache.karaf.docker.command.DockerCommandSupport;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="docker", name="search", description="Search the Docker Hub for images")
@Service
public class SearchCommand
extends DockerCommandSupport {
    @Argument(index=0, name="term", description="Search term", required=true, multiValued=false)
    String term;

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("Name");
        table.column("Description");
        table.column("Automated");
        table.column("Official");
        table.column("Star Count");
        for (ImageSearch search : this.getDockerService().search(this.term, this.url)) {
            table.addRow().addContent(new Object[]{search.getName(), search.getDescription(), search.isAutomated(), search.isOfficial(), search.getStarCount()});
        }
        table.print(System.out);
        return null;
    }
}

