/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.docker.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.karaf.docker.Container;
import org.apache.karaf.docker.ContainerConfig;
import org.apache.karaf.docker.DockerClient;
import org.apache.karaf.docker.DockerService;
import org.apache.karaf.docker.HostConfig;
import org.apache.karaf.docker.HostPortBinding;
import org.apache.karaf.docker.Image;
import org.apache.karaf.docker.ImageHistory;
import org.apache.karaf.docker.ImageSearch;
import org.apache.karaf.docker.Info;
import org.apache.karaf.docker.Top;
import org.apache.karaf.docker.Version;

public class DockerServiceImpl
implements DockerService {
    private File storageLocation;

    public File getStorageLocation() {
        return this.storageLocation;
    }

    public void setStorageLocation(File storageLocation) {
        this.storageLocation = storageLocation;
    }

    @Override
    public List<Container> ps(boolean showAll, String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        return dockerClient.ps(showAll);
    }

    @Override
    public Info info(String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        return dockerClient.info();
    }

    @Override
    public Version version(String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        return dockerClient.version();
    }

    @Override
    public void create(String name, String url) throws Exception {
        this.pull("java", "8-jre-alpine", true, url);
        ContainerConfig config = new ContainerConfig();
        config.setTty(true);
        config.setAttachStdin(true);
        config.setAttachStderr(true);
        config.setAttachStdout(true);
        config.setImage("java:8-jre-alpine");
        config.setHostname("");
        config.setUser("");
        config.setCmd(new String[]{"/opt/apache-karaf/bin/karaf"});
        config.setWorkingDir("");
        config.setOpenStdin(true);
        config.setStdinOnce(true);
        HashMap<String, Map<String, String>> exposedPorts = new HashMap<String, Map<String, String>>();
        exposedPorts.put("8101/tcp", new HashMap());
        exposedPorts.put("1099/tcp", new HashMap());
        exposedPorts.put("44444/tcp", new HashMap());
        exposedPorts.put("8181/tcp", new HashMap());
        config.setExposedPorts(exposedPorts);
        HostConfig hostConfig = new HostConfig();
        hostConfig.setPrivileged(false);
        hostConfig.setPublishAllPorts(false);
        File containerStorage = new File(this.storageLocation, name);
        if (containerStorage.exists()) {
            hostConfig.setBinds(new String[]{containerStorage.getAbsolutePath() + ":/opt/apache-karaf"});
        }
        hostConfig.setNetworkMode("bridge");
        hostConfig.setLxcConf(new String[0]);
        HashMap<String, List<HostPortBinding>> portBindings = new HashMap<String, List<HostPortBinding>>();
        ArrayList<HostPortBinding> sshPortBindings = new ArrayList<HostPortBinding>();
        HostPortBinding sshPortBinding = new HostPortBinding();
        sshPortBinding.setHostIp("");
        sshPortBinding.setHostPort("8101");
        sshPortBindings.add(sshPortBinding);
        portBindings.put("8101/tcp", sshPortBindings);
        ArrayList<HostPortBinding> jmxPortBindings = new ArrayList<HostPortBinding>();
        HostPortBinding jmxPortBinding = new HostPortBinding();
        jmxPortBinding.setHostIp("");
        jmxPortBinding.setHostPort("1099");
        jmxPortBindings.add(jmxPortBinding);
        portBindings.put("1099/tcp", jmxPortBindings);
        ArrayList<HostPortBinding> jmxRegistryPortBindings = new ArrayList<HostPortBinding>();
        HostPortBinding jmxRegistryPortBinding = new HostPortBinding();
        jmxRegistryPortBinding.setHostIp("");
        jmxRegistryPortBinding.setHostPort("44444");
        jmxRegistryPortBindings.add(jmxRegistryPortBinding);
        portBindings.put("44444/tcp", jmxRegistryPortBindings);
        ArrayList<HostPortBinding> httpPortBindings = new ArrayList<HostPortBinding>();
        HostPortBinding httpPortBinding = new HostPortBinding();
        httpPortBinding.setHostIp("");
        httpPortBinding.setHostPort("8181");
        httpPortBindings.add(httpPortBinding);
        portBindings.put("8181/tcp", httpPortBindings);
        hostConfig.setPortBindings(portBindings);
        config.setHostConfig(hostConfig);
        this.create(name, url, config);
    }

    @Override
    public void create(String name, String url, ContainerConfig config) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        dockerClient.create(config, name);
    }

    @Override
    public void provision(String name, String sshPort, String jmxRmiPort, String jmxRmiRegistryPort, String httpPort, boolean copy, String url) throws Exception {
        File containerStorage;
        this.pull("java", "8-jre-alpine", true, url);
        File karafBase = new File(System.getProperty("karaf.base"));
        if (copy) {
            containerStorage = new File(this.storageLocation, name);
            containerStorage.mkdirs();
            this.copy(karafBase, containerStorage);
            this.chmod(new File(containerStorage, "bin/karaf"), "a+x");
            this.chmod(new File(containerStorage, "bin/client"), "a+x");
            this.chmod(new File(containerStorage, "bin/inc"), "a+x");
            this.chmod(new File(containerStorage, "bin/instance"), "a+x");
            this.chmod(new File(containerStorage, "bin/setenv"), "a+x");
            this.chmod(new File(containerStorage, "bin/shell"), "a+x");
            this.chmod(new File(containerStorage, "bin/start"), "a+x");
            this.chmod(new File(containerStorage, "bin/status"), "a+x");
            this.chmod(new File(containerStorage, "bin/stop"), "a+x");
        } else {
            containerStorage = karafBase;
        }
        DockerClient dockerClient = new DockerClient(url);
        ContainerConfig config = new ContainerConfig();
        config.setTty(true);
        config.setAttachStdout(true);
        config.setAttachStderr(true);
        config.setAttachStdin(true);
        config.setImage("java:8-jre-alpine");
        config.setHostname("");
        config.setUser("");
        config.setCmd(new String[]{"/opt/apache-karaf/bin/karaf"});
        config.setWorkingDir("");
        config.setOpenStdin(true);
        config.setStdinOnce(true);
        HashMap<String, Map<String, String>> exposedPorts = new HashMap<String, Map<String, String>>();
        exposedPorts.put("8101/tcp", new HashMap());
        exposedPorts.put("1099/tcp", new HashMap());
        exposedPorts.put("44444/tcp", new HashMap());
        exposedPorts.put("8181/tcp", new HashMap());
        config.setExposedPorts(exposedPorts);
        HostConfig hostConfig = new HostConfig();
        hostConfig.setPrivileged(false);
        hostConfig.setPublishAllPorts(false);
        hostConfig.setBinds(new String[]{containerStorage.getAbsolutePath() + ":/opt/apache-karaf"});
        hostConfig.setNetworkMode("bridge");
        hostConfig.setLxcConf(new String[0]);
        HashMap<String, List<HostPortBinding>> portBindings = new HashMap<String, List<HostPortBinding>>();
        ArrayList<HostPortBinding> sshPortBindings = new ArrayList<HostPortBinding>();
        HostPortBinding sshPortBinding = new HostPortBinding();
        sshPortBinding.setHostIp("");
        sshPortBinding.setHostPort(sshPort);
        sshPortBindings.add(sshPortBinding);
        portBindings.put("8101/tcp", sshPortBindings);
        ArrayList<HostPortBinding> jmxPortBindings = new ArrayList<HostPortBinding>();
        HostPortBinding jmxPortBinding = new HostPortBinding();
        jmxPortBinding.setHostIp("");
        jmxPortBinding.setHostPort(jmxRmiPort);
        jmxPortBindings.add(jmxPortBinding);
        portBindings.put("1099/tcp", jmxPortBindings);
        ArrayList<HostPortBinding> jmxRegistryPortBindings = new ArrayList<HostPortBinding>();
        HostPortBinding jmxRegistryPortBinding = new HostPortBinding();
        jmxRegistryPortBinding.setHostIp("");
        jmxRegistryPortBinding.setHostPort(jmxRmiRegistryPort);
        jmxRegistryPortBindings.add(jmxRegistryPortBinding);
        portBindings.put("44444/tcp", jmxRegistryPortBindings);
        ArrayList<HostPortBinding> httpPortBindings = new ArrayList<HostPortBinding>();
        HostPortBinding httpPortBinding = new HostPortBinding();
        httpPortBinding.setHostIp("");
        httpPortBinding.setHostPort(httpPort);
        httpPortBindings.add(httpPortBinding);
        portBindings.put("8181/tcp", httpPortBindings);
        hostConfig.setPortBindings(portBindings);
        config.setHostConfig(hostConfig);
        dockerClient.create(config, name);
    }

    @Override
    public void start(String name, String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        dockerClient.start(name);
    }

    @Override
    public void stop(String name, int timeToWait, String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        dockerClient.stop(name, timeToWait);
    }

    @Override
    public void restart(String name, int timeToWait, String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        dockerClient.restart(name, timeToWait);
    }

    @Override
    public void kill(String name, String signal, String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        dockerClient.kill(name, signal);
    }

    @Override
    public void pause(String name, String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        dockerClient.pause(name);
    }

    @Override
    public void unpause(String name, String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        dockerClient.unpause(name);
    }

    @Override
    public void rename(String name, String newName, String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        dockerClient.rename(name, newName);
    }

    @Override
    public void rm(String name, boolean removeVolumes, boolean force, String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        dockerClient.rm(name, removeVolumes, force);
        File containerStorage = new File(this.storageLocation, name);
        if (containerStorage.exists()) {
            containerStorage.delete();
        }
    }

    @Override
    public String logs(String name, boolean stdout, boolean stderr, boolean timestamps, boolean details, String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        String log = dockerClient.logs(name, stdout, stderr, timestamps, details);
        return log;
    }

    @Override
    public Top top(String name, String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        return dockerClient.top(name);
    }

    @Override
    public void commit(String name, String repo, String tag, String message, String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        dockerClient.commit(name, null, message, repo, tag);
    }

    @Override
    public List<Image> images(String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        return dockerClient.images(true);
    }

    @Override
    public void pull(String image, String tag, boolean verbose, String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        dockerClient.pull(image, tag, verbose);
    }

    @Override
    public List<ImageSearch> search(String term, String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        return dockerClient.search(term);
    }

    @Override
    public Container inspect(String name, String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        return dockerClient.inspect(name);
    }

    @Override
    public void push(String image, String tag, boolean verbose, String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        dockerClient.push(image, tag, verbose);
    }

    @Override
    public List<ImageHistory> history(String image, String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        return dockerClient.history(image);
    }

    @Override
    public void tag(String image, String repo, String tag, String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        dockerClient.tag(image, repo, tag);
    }

    @Override
    public void rmi(String image, boolean force, boolean noprune, String url) throws Exception {
        DockerClient dockerClient = new DockerClient(url);
        dockerClient.rmi(image, force, noprune);
    }

    private void copy(File source, File destination) throws IOException {
        if (source.getName().equals("docker")) {
            return;
        }
        if (source.getName().equals("cache.lock")) {
            return;
        }
        if (source.getName().equals("lock")) {
            return;
        }
        if (source.getName().matches("transaction_\\d+\\.log")) {
            return;
        }
        if (source.isDirectory()) {
            String[] children;
            if (!destination.exists()) {
                destination.mkdirs();
            }
            for (String child : children = source.list()) {
                this.copy(new File(source, child), new File(destination, child));
            }
        } else {
            try (FileInputStream in = new FileInputStream(source);
                 FileOutputStream out = new FileOutputStream(destination);){
                new StreamUtils().copy(in, out);
            }
        }
    }

    private int chmod(File serviceFile, String mode) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command("chmod", mode, serviceFile.getCanonicalPath());
        Process p = builder.start();
        try {
            return p.waitFor();
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
    }

    class StreamUtils {
        public void close(Closeable ... closeables) {
            for (Closeable c : closeables) {
                try {
                    if (c == null) continue;
                    c.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void close(Iterable<Closeable> closeables) {
            for (Closeable c : closeables) {
                try {
                    if (c == null) continue;
                    c.close();
                }
                catch (IOException iOException) {}
            }
        }

        public void copy(InputStream input, OutputStream output) throws IOException {
            int n;
            byte[] buffer = new byte[16384];
            while ((n = input.read(buffer)) > 0) {
                output.write(buffer, 0, n);
            }
            output.flush();
        }
    }
}

