/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.Destination;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.Source;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.SupportingLink;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.IgpEventType;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.IgpLinkAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.IgpLinkEvent;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.L3UnicastIgpTopologyType;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.l3.unicast.igp.topology.type.L3UnicastIgpTopology;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class IgpLinkEventBuilder
implements Builder<IgpLinkEvent> {
    private Destination _destination;
    private IgpEventType _igpEventType;
    private org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.igp.link.attributes.IgpLinkAttributes _igpLinkAttributes;
    private L3UnicastIgpTopology _l3UnicastIgpTopology;
    private LinkId _linkId;
    private Source _source;
    private List<SupportingLink> _supportingLink;
    private TopologyId _topologyRef;
    Map<Class<? extends Augmentation<IgpLinkEvent>>, Augmentation<IgpLinkEvent>> augmentation = Collections.emptyMap();

    public IgpLinkEventBuilder() {
    }

    public IgpLinkEventBuilder(IgpLinkAttributes arg) {
        this._igpLinkAttributes = arg.getIgpLinkAttributes();
    }

    public IgpLinkEventBuilder(L3UnicastIgpTopologyType arg) {
        this._l3UnicastIgpTopology = arg.getL3UnicastIgpTopology();
    }

    public IgpLinkEventBuilder(LinkAttributes arg) {
        this._linkId = arg.getLinkId();
        this._source = arg.getSource();
        this._destination = arg.getDestination();
        this._supportingLink = arg.getSupportingLink();
    }

    public IgpLinkEventBuilder(IgpLinkEvent base) {
        Map aug;
        this._destination = base.getDestination();
        this._igpEventType = base.getIgpEventType();
        this._igpLinkAttributes = base.getIgpLinkAttributes();
        this._l3UnicastIgpTopology = base.getL3UnicastIgpTopology();
        this._linkId = base.getLinkId();
        this._source = base.getSource();
        this._supportingLink = base.getSupportingLink();
        this._topologyRef = base.getTopologyRef();
        if (base instanceof IgpLinkEventImpl) {
            IgpLinkEventImpl impl = (IgpLinkEventImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<IgpLinkEvent>>, Augmentation<IgpLinkEvent>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IgpLinkEvent>>, Augmentation<IgpLinkEvent>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof IgpLinkAttributes) {
            this._igpLinkAttributes = ((IgpLinkAttributes)arg).getIgpLinkAttributes();
            isValidArg = true;
        }
        if (arg instanceof LinkAttributes) {
            this._linkId = ((LinkAttributes)arg).getLinkId();
            this._source = ((LinkAttributes)arg).getSource();
            this._destination = ((LinkAttributes)arg).getDestination();
            this._supportingLink = ((LinkAttributes)arg).getSupportingLink();
            isValidArg = true;
        }
        if (arg instanceof L3UnicastIgpTopologyType) {
            this._l3UnicastIgpTopology = ((L3UnicastIgpTopologyType)arg).getL3UnicastIgpTopology();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.IgpLinkAttributes, org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkAttributes, org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.L3UnicastIgpTopologyType]");
    }

    public Destination getDestination() {
        return this._destination;
    }

    public IgpEventType getIgpEventType() {
        return this._igpEventType;
    }

    public org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.igp.link.attributes.IgpLinkAttributes getIgpLinkAttributes() {
        return this._igpLinkAttributes;
    }

    public L3UnicastIgpTopology getL3UnicastIgpTopology() {
        return this._l3UnicastIgpTopology;
    }

    public LinkId getLinkId() {
        return this._linkId;
    }

    public Source getSource() {
        return this._source;
    }

    public List<SupportingLink> getSupportingLink() {
        return this._supportingLink;
    }

    public TopologyId getTopologyRef() {
        return this._topologyRef;
    }

    public <E$$ extends Augmentation<IgpLinkEvent>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public IgpLinkEventBuilder setDestination(Destination value) {
        this._destination = value;
        return this;
    }

    public IgpLinkEventBuilder setIgpEventType(IgpEventType value) {
        this._igpEventType = value;
        return this;
    }

    public IgpLinkEventBuilder setIgpLinkAttributes(org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.igp.link.attributes.IgpLinkAttributes value) {
        this._igpLinkAttributes = value;
        return this;
    }

    public IgpLinkEventBuilder setL3UnicastIgpTopology(L3UnicastIgpTopology value) {
        this._l3UnicastIgpTopology = value;
        return this;
    }

    public IgpLinkEventBuilder setLinkId(LinkId value) {
        this._linkId = value;
        return this;
    }

    public IgpLinkEventBuilder setSource(Source value) {
        this._source = value;
        return this;
    }

    public IgpLinkEventBuilder setSupportingLink(List<SupportingLink> values) {
        this._supportingLink = values;
        return this;
    }

    public IgpLinkEventBuilder setTopologyRef(TopologyId value) {
        this._topologyRef = value;
        return this;
    }

    public IgpLinkEventBuilder addAugmentation(Class<? extends Augmentation<IgpLinkEvent>> augmentationType, Augmentation<IgpLinkEvent> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IgpLinkEvent>>, Augmentation<IgpLinkEvent>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public IgpLinkEventBuilder removeAugmentation(Class<? extends Augmentation<IgpLinkEvent>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public IgpLinkEvent build() {
        return new IgpLinkEventImpl(this);
    }

    private static final class IgpLinkEventImpl
    implements IgpLinkEvent {
        private final Destination _destination;
        private final IgpEventType _igpEventType;
        private final org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.igp.link.attributes.IgpLinkAttributes _igpLinkAttributes;
        private final L3UnicastIgpTopology _l3UnicastIgpTopology;
        private final LinkId _linkId;
        private final Source _source;
        private final List<SupportingLink> _supportingLink;
        private final TopologyId _topologyRef;
        private Map<Class<? extends Augmentation<IgpLinkEvent>>, Augmentation<IgpLinkEvent>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        IgpLinkEventImpl(IgpLinkEventBuilder base) {
            this._destination = base.getDestination();
            this._igpEventType = base.getIgpEventType();
            this._igpLinkAttributes = base.getIgpLinkAttributes();
            this._l3UnicastIgpTopology = base.getL3UnicastIgpTopology();
            this._linkId = base.getLinkId();
            this._source = base.getSource();
            this._supportingLink = base.getSupportingLink();
            this._topologyRef = base.getTopologyRef();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<IgpLinkEvent> getImplementedInterface() {
            return IgpLinkEvent.class;
        }

        public Destination getDestination() {
            return this._destination;
        }

        @Override
        public IgpEventType getIgpEventType() {
            return this._igpEventType;
        }

        @Override
        public org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.igp.link.attributes.IgpLinkAttributes getIgpLinkAttributes() {
            return this._igpLinkAttributes;
        }

        @Override
        public L3UnicastIgpTopology getL3UnicastIgpTopology() {
            return this._l3UnicastIgpTopology;
        }

        public LinkId getLinkId() {
            return this._linkId;
        }

        public Source getSource() {
            return this._source;
        }

        public List<SupportingLink> getSupportingLink() {
            return this._supportingLink;
        }

        @Override
        public TopologyId getTopologyRef() {
            return this._topologyRef;
        }

        public <E$$ extends Augmentation<IgpLinkEvent>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._destination);
            result = 31 * result + Objects.hashCode((Object)this._igpEventType);
            result = 31 * result + Objects.hashCode(this._igpLinkAttributes);
            result = 31 * result + Objects.hashCode(this._l3UnicastIgpTopology);
            result = 31 * result + Objects.hashCode(this._linkId);
            result = 31 * result + Objects.hashCode(this._source);
            result = 31 * result + Objects.hashCode(this._supportingLink);
            result = 31 * result + Objects.hashCode(this._topologyRef);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!IgpLinkEvent.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            IgpLinkEvent other = (IgpLinkEvent)obj;
            if (!Objects.equals(this._destination, other.getDestination())) {
                return false;
            }
            if (!Objects.equals((Object)this._igpEventType, (Object)other.getIgpEventType())) {
                return false;
            }
            if (!Objects.equals(this._igpLinkAttributes, other.getIgpLinkAttributes())) {
                return false;
            }
            if (!Objects.equals(this._l3UnicastIgpTopology, other.getL3UnicastIgpTopology())) {
                return false;
            }
            if (!Objects.equals(this._linkId, other.getLinkId())) {
                return false;
            }
            if (!Objects.equals(this._source, other.getSource())) {
                return false;
            }
            if (!Objects.equals(this._supportingLink, other.getSupportingLink())) {
                return false;
            }
            if (!Objects.equals(this._topologyRef, other.getTopologyRef())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                IgpLinkEventImpl otherImpl = (IgpLinkEventImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<IgpLinkEvent>>, Augmentation<IgpLinkEvent>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"IgpLinkEvent");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_destination", (Object)this._destination);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_igpEventType", (Object)((Object)this._igpEventType));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_igpLinkAttributes", (Object)this._igpLinkAttributes);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_l3UnicastIgpTopology", (Object)this._l3UnicastIgpTopology);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_linkId", (Object)this._linkId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_source", (Object)this._source);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_supportingLink", this._supportingLink);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_topologyRef", (Object)this._topologyRef);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

