/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.IgpEventType;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.IgpPrefixEvent;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.L3UnicastIgpTopologyType;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.igp.prefix.event.Prefix;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.l3.unicast.igp.topology.type.L3UnicastIgpTopology;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class IgpPrefixEventBuilder
implements Builder<IgpPrefixEvent> {
    private IgpEventType _igpEventType;
    private L3UnicastIgpTopology _l3UnicastIgpTopology;
    private NodeId _nodeRef;
    private Prefix _prefix;
    private TopologyId _topologyRef;
    Map<Class<? extends Augmentation<IgpPrefixEvent>>, Augmentation<IgpPrefixEvent>> augmentation = Collections.emptyMap();

    public IgpPrefixEventBuilder() {
    }

    public IgpPrefixEventBuilder(L3UnicastIgpTopologyType arg) {
        this._l3UnicastIgpTopology = arg.getL3UnicastIgpTopology();
    }

    public IgpPrefixEventBuilder(IgpPrefixEvent base) {
        Map aug;
        this._igpEventType = base.getIgpEventType();
        this._l3UnicastIgpTopology = base.getL3UnicastIgpTopology();
        this._nodeRef = base.getNodeRef();
        this._prefix = base.getPrefix();
        this._topologyRef = base.getTopologyRef();
        if (base instanceof IgpPrefixEventImpl) {
            IgpPrefixEventImpl impl = (IgpPrefixEventImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<IgpPrefixEvent>>, Augmentation<IgpPrefixEvent>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IgpPrefixEvent>>, Augmentation<IgpPrefixEvent>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof L3UnicastIgpTopologyType) {
            this._l3UnicastIgpTopology = ((L3UnicastIgpTopologyType)arg).getL3UnicastIgpTopology();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.nt.l3.unicast.igp.topology.rev131021.L3UnicastIgpTopologyType]");
    }

    public IgpEventType getIgpEventType() {
        return this._igpEventType;
    }

    public L3UnicastIgpTopology getL3UnicastIgpTopology() {
        return this._l3UnicastIgpTopology;
    }

    public NodeId getNodeRef() {
        return this._nodeRef;
    }

    public Prefix getPrefix() {
        return this._prefix;
    }

    public TopologyId getTopologyRef() {
        return this._topologyRef;
    }

    public <E$$ extends Augmentation<IgpPrefixEvent>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public IgpPrefixEventBuilder setIgpEventType(IgpEventType value) {
        this._igpEventType = value;
        return this;
    }

    public IgpPrefixEventBuilder setL3UnicastIgpTopology(L3UnicastIgpTopology value) {
        this._l3UnicastIgpTopology = value;
        return this;
    }

    public IgpPrefixEventBuilder setNodeRef(NodeId value) {
        this._nodeRef = value;
        return this;
    }

    public IgpPrefixEventBuilder setPrefix(Prefix value) {
        this._prefix = value;
        return this;
    }

    public IgpPrefixEventBuilder setTopologyRef(TopologyId value) {
        this._topologyRef = value;
        return this;
    }

    public IgpPrefixEventBuilder addAugmentation(Class<? extends Augmentation<IgpPrefixEvent>> augmentationType, Augmentation<IgpPrefixEvent> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IgpPrefixEvent>>, Augmentation<IgpPrefixEvent>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public IgpPrefixEventBuilder removeAugmentation(Class<? extends Augmentation<IgpPrefixEvent>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public IgpPrefixEvent build() {
        return new IgpPrefixEventImpl(this);
    }

    private static final class IgpPrefixEventImpl
    implements IgpPrefixEvent {
        private final IgpEventType _igpEventType;
        private final L3UnicastIgpTopology _l3UnicastIgpTopology;
        private final NodeId _nodeRef;
        private final Prefix _prefix;
        private final TopologyId _topologyRef;
        private Map<Class<? extends Augmentation<IgpPrefixEvent>>, Augmentation<IgpPrefixEvent>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        IgpPrefixEventImpl(IgpPrefixEventBuilder base) {
            this._igpEventType = base.getIgpEventType();
            this._l3UnicastIgpTopology = base.getL3UnicastIgpTopology();
            this._nodeRef = base.getNodeRef();
            this._prefix = base.getPrefix();
            this._topologyRef = base.getTopologyRef();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<IgpPrefixEvent> getImplementedInterface() {
            return IgpPrefixEvent.class;
        }

        @Override
        public IgpEventType getIgpEventType() {
            return this._igpEventType;
        }

        @Override
        public L3UnicastIgpTopology getL3UnicastIgpTopology() {
            return this._l3UnicastIgpTopology;
        }

        @Override
        public NodeId getNodeRef() {
            return this._nodeRef;
        }

        @Override
        public Prefix getPrefix() {
            return this._prefix;
        }

        @Override
        public TopologyId getTopologyRef() {
            return this._topologyRef;
        }

        public <E$$ extends Augmentation<IgpPrefixEvent>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._igpEventType);
            result = 31 * result + Objects.hashCode(this._l3UnicastIgpTopology);
            result = 31 * result + Objects.hashCode(this._nodeRef);
            result = 31 * result + Objects.hashCode(this._prefix);
            result = 31 * result + Objects.hashCode(this._topologyRef);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!IgpPrefixEvent.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            IgpPrefixEvent other = (IgpPrefixEvent)obj;
            if (!Objects.equals((Object)this._igpEventType, (Object)other.getIgpEventType())) {
                return false;
            }
            if (!Objects.equals(this._l3UnicastIgpTopology, other.getL3UnicastIgpTopology())) {
                return false;
            }
            if (!Objects.equals(this._nodeRef, other.getNodeRef())) {
                return false;
            }
            if (!Objects.equals(this._prefix, other.getPrefix())) {
                return false;
            }
            if (!Objects.equals(this._topologyRef, other.getTopologyRef())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                IgpPrefixEventImpl otherImpl = (IgpPrefixEventImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<IgpPrefixEvent>>, Augmentation<IgpPrefixEvent>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"IgpPrefixEvent");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_igpEventType", (Object)((Object)this._igpEventType));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_l3UnicastIgpTopology", (Object)this._l3UnicastIgpTopology);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_nodeRef", (Object)this._nodeRef);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_prefix", (Object)this._prefix);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_topologyRef", (Object)this._topologyRef);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

