/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.zmq;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.ProgressivePromise;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import org.opendaylight.jsonrpc.bus.api.MessageListener;
import org.opendaylight.jsonrpc.bus.api.PeerContext;
import org.opendaylight.jsonrpc.bus.spi.CommonConstants;
import org.opendaylight.jsonrpc.bus.zmq.Message;
import org.opendaylight.jsonrpc.bus.zmq.PeerContextImpl;
import org.opendaylight.jsonrpc.bus.zmq.ProtocolObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClientHandler
extends SimpleChannelInboundHandler<ProtocolObject> {
    private static final Logger LOG = LoggerFactory.getLogger(ClientHandler.class);
    private final MessageListener listener;
    private boolean first = true;

    ClientHandler(MessageListener listener) {
        this.listener = listener;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ProtocolObject msg) throws Exception {
        PeerContextImpl peer = (PeerContextImpl)((Object)ctx.channel().attr(CommonConstants.ATTR_PEER_CONTEXT).get());
        LOG.debug("Message : {}@{}", (Object)msg, (Object)peer);
        ByteBuf buffer = msg.toBuffer();
        if (this.first && !buffer.isReadable()) {
            LOG.debug("First empty frame discarded : {}", (Object)msg);
        } else {
            this.checkLast((Message)msg);
            String bufferContent = buffer.toString(StandardCharsets.UTF_8);
            ProgressivePromise promise = ((AtomicReference)ctx.channel().attr(CommonConstants.ATTR_RESPONSE_QUEUE).get()).getAndSet(null);
            if (promise != null) {
                promise.trySuccess((Object)bufferContent);
            }
            this.listener.onMessage((PeerContext)peer, bufferContent);
        }
        buffer.release();
    }

    private void checkLast(Message msg) {
        if (msg.last()) {
            this.first = true;
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error("Caught exception on {}, closing now", (Object)ctx.channel(), (Object)cause);
    }
}

