/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.zmq;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.channel.Channel;
import org.opendaylight.jsonrpc.bus.api.SessionType;
import org.opendaylight.jsonrpc.bus.spi.AbstractPeerContext;
import org.opendaylight.jsonrpc.bus.zmq.Util;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public class PeerContextImpl
extends AbstractPeerContext {
    private boolean isServerSocket;
    private SessionType socketType;
    private String identity;

    public PeerContextImpl(Channel channel) {
        super(channel, "zmq");
    }

    public void setServerSocket(boolean isServer) {
        this.isServerSocket = isServer;
    }

    public void setSocketType(SessionType socketType) {
        this.socketType = socketType;
    }

    public SessionType getSocketType() {
        return this.socketType;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public boolean isServerSocket() {
        return this.isServerSocket;
    }

    public void send(String message) {
        this.channel.writeAndFlush((Object)Util.serializeMessage(message));
    }

    public String toString() {
        return "PeerContextImpl [channel=" + this.channel() + ", isServer=" + this.isServerSocket() + ", socketType=" + this.getSocketType() + ", identity=" + this.getIdentity() + "]";
    }
}

