/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.zmq;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.EventExecutorGroup;
import org.opendaylight.jsonrpc.bus.api.MessageListener;
import org.opendaylight.jsonrpc.bus.api.SessionType;
import org.opendaylight.jsonrpc.bus.spi.AbstractServerChannelInitializer;
import org.opendaylight.jsonrpc.bus.spi.ChannelGroupHandler;
import org.opendaylight.jsonrpc.bus.spi.CommonConstants;
import org.opendaylight.jsonrpc.bus.zmq.HandshakeHandler;
import org.opendaylight.jsonrpc.bus.zmq.MessageDecoder;
import org.opendaylight.jsonrpc.bus.zmq.MessageEncoder;
import org.opendaylight.jsonrpc.bus.zmq.PeerContextImpl;
import org.opendaylight.jsonrpc.bus.zmq.ServerHandler;

public class ServerInitializer
extends AbstractServerChannelInitializer {
    public ServerInitializer(ChannelGroup channelGroup, MessageListener messageListener, SessionType socketType, EventExecutorGroup handlerExecutor) {
        super(socketType, handlerExecutor, channelGroup, messageListener);
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        super.initChannel(ch);
        ch.attr(CommonConstants.ATTR_PEER_CONTEXT).set((Object)new PeerContextImpl((Channel)ch));
        ServerInitializer.configureLogging((Channel)ch);
        ch.pipeline().addLast("conn-tracker", (ChannelHandler)new ChannelGroupHandler(this.channelGroup));
        ch.pipeline().addLast("handshake", (ChannelHandler)new HandshakeHandler());
        ch.pipeline().addLast("decoder", (ChannelHandler)new MessageEncoder());
        ch.pipeline().addLast("encoder", (ChannelHandler)new MessageDecoder());
        ch.pipeline().addLast(this.handlerExecutor, "listener-adapter", (ChannelHandler)new ServerHandler(this.messageListener));
    }
}

