/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.zmq;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.opendaylight.jsonrpc.bus.zmq.Message;
import org.opendaylight.jsonrpc.bus.zmq.Util;

public class SubscribeMessage
implements Message {
    private final String topic;

    public SubscribeMessage(ByteBuf buffer) {
        Util.ensureEnoughData(3, buffer);
        buffer.skipBytes(1);
        byte len = buffer.readByte();
        Util.ensureEnoughData(len, buffer);
        buffer.skipBytes(1);
        this.topic = buffer.readCharSequence(len - 1, StandardCharsets.US_ASCII).toString();
    }

    public SubscribeMessage(String topic) {
        this.topic = Objects.requireNonNull(topic);
    }

    @Override
    public ByteBuf toBuffer() {
        ByteBuf content = Unpooled.buffer();
        content.writeByte(0);
        content.writeByte(this.topic.length() + 1);
        content.writeByte(1);
        content.writeCharSequence((CharSequence)this.topic, StandardCharsets.US_ASCII);
        return content;
    }

    public String topic() {
        return this.topic;
    }

    @Override
    public boolean last() {
        return true;
    }
}

