/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.zmq;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.opendaylight.jsonrpc.bus.api.SessionType;
import org.opendaylight.jsonrpc.bus.zmq.CompositeMessage;
import org.opendaylight.jsonrpc.bus.zmq.DefaultCompositeMessage;
import org.opendaylight.jsonrpc.bus.zmq.DefaultMessage;

final class Util {
    private static final Multimap<SessionType, SessionType> MATRIX_SOCKET = ArrayListMultimap.create();

    private Util() {
    }

    public static void ensureEnoughData(int expected, ByteBuf buffer) {
        int actual = buffer.readableBytes();
        if (actual < expected) {
            throw new IllegalArgumentException(String.format("Not enough data in buffer. Expected at least %d, but got %d", expected, actual));
        }
    }

    public static boolean assertSocketType(SessionType thisSocket, SessionType remoteSocket) {
        return MATRIX_SOCKET.get((Object)thisSocket).contains(remoteSocket);
    }

    public static CompositeMessage serializeMessage(String message) {
        ByteBuf buffer = Unpooled.buffer();
        buffer.writeCharSequence((CharSequence)message, StandardCharsets.UTF_8);
        return new DefaultCompositeMessage(new DefaultMessage(false, Unpooled.EMPTY_BUFFER), new DefaultMessage(true, buffer));
    }

    static {
        MATRIX_SOCKET.put((Object)SessionType.REP, (Object)SessionType.REQ);
        MATRIX_SOCKET.put((Object)SessionType.REQ, (Object)SessionType.REP);
        MATRIX_SOCKET.put((Object)SessionType.PUB, (Object)SessionType.SUB);
        MATRIX_SOCKET.put((Object)SessionType.SUB, (Object)SessionType.PUB);
    }
}

