/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.common.rev170215.IdGrouping;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.TransactionsParams;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.WriteTransactionsInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class WriteTransactionsInputBuilder
implements Builder<WriteTransactionsInput> {
    private String _id;
    private Long _seconds;
    private Long _transactionsPerSecond;
    private Boolean _chainedTransactions;
    Map<Class<? extends Augmentation<WriteTransactionsInput>>, Augmentation<WriteTransactionsInput>> augmentation = Collections.emptyMap();

    public WriteTransactionsInputBuilder() {
    }

    public WriteTransactionsInputBuilder(TransactionsParams arg) {
        this._seconds = arg.getSeconds();
        this._transactionsPerSecond = arg.getTransactionsPerSecond();
    }

    public WriteTransactionsInputBuilder(IdGrouping arg) {
        this._id = arg.getId();
    }

    public WriteTransactionsInputBuilder(WriteTransactionsInput base) {
        Map aug;
        this._id = base.getId();
        this._seconds = base.getSeconds();
        this._transactionsPerSecond = base.getTransactionsPerSecond();
        this._chainedTransactions = base.isChainedTransactions();
        if (base instanceof WriteTransactionsInputImpl) {
            WriteTransactionsInputImpl impl = (WriteTransactionsInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<WriteTransactionsInput>>, Augmentation<WriteTransactionsInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<WriteTransactionsInput>>, Augmentation<WriteTransactionsInput>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof IdGrouping) {
            this._id = ((IdGrouping)arg).getId();
            isValidArg = true;
        }
        if (arg instanceof TransactionsParams) {
            this._seconds = ((TransactionsParams)arg).getSeconds();
            this._transactionsPerSecond = ((TransactionsParams)arg).getTransactionsPerSecond();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.common.rev170215.IdGrouping, org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.TransactionsParams]");
    }

    public String getId() {
        return this._id;
    }

    public Long getSeconds() {
        return this._seconds;
    }

    public Long getTransactionsPerSecond() {
        return this._transactionsPerSecond;
    }

    public Boolean isChainedTransactions() {
        return this._chainedTransactions;
    }

    public <E$$ extends Augmentation<WriteTransactionsInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public WriteTransactionsInputBuilder setId(String value) {
        this._id = value;
        return this;
    }

    private static void checkSecondsRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public WriteTransactionsInputBuilder setSeconds(Long value) {
        if (value != null) {
            WriteTransactionsInputBuilder.checkSecondsRange(value);
        }
        this._seconds = value;
        return this;
    }

    private static void checkTransactionsPerSecondRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public WriteTransactionsInputBuilder setTransactionsPerSecond(Long value) {
        if (value != null) {
            WriteTransactionsInputBuilder.checkTransactionsPerSecondRange(value);
        }
        this._transactionsPerSecond = value;
        return this;
    }

    public WriteTransactionsInputBuilder setChainedTransactions(Boolean value) {
        this._chainedTransactions = value;
        return this;
    }

    public WriteTransactionsInputBuilder addAugmentation(Class<? extends Augmentation<WriteTransactionsInput>> augmentationType, Augmentation<WriteTransactionsInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<WriteTransactionsInput>>, Augmentation<WriteTransactionsInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public WriteTransactionsInputBuilder removeAugmentation(Class<? extends Augmentation<WriteTransactionsInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public WriteTransactionsInput build() {
        return new WriteTransactionsInputImpl(this);
    }

    private static final class WriteTransactionsInputImpl
    implements WriteTransactionsInput {
        private final String _id;
        private final Long _seconds;
        private final Long _transactionsPerSecond;
        private final Boolean _chainedTransactions;
        private Map<Class<? extends Augmentation<WriteTransactionsInput>>, Augmentation<WriteTransactionsInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        WriteTransactionsInputImpl(WriteTransactionsInputBuilder base) {
            this._id = base.getId();
            this._seconds = base.getSeconds();
            this._transactionsPerSecond = base.getTransactionsPerSecond();
            this._chainedTransactions = base.isChainedTransactions();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<WriteTransactionsInput> getImplementedInterface() {
            return WriteTransactionsInput.class;
        }

        @Override
        public String getId() {
            return this._id;
        }

        @Override
        public Long getSeconds() {
            return this._seconds;
        }

        @Override
        public Long getTransactionsPerSecond() {
            return this._transactionsPerSecond;
        }

        @Override
        public Boolean isChainedTransactions() {
            return this._chainedTransactions;
        }

        public <E$$ extends Augmentation<WriteTransactionsInput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._id);
            result = 31 * result + Objects.hashCode(this._seconds);
            result = 31 * result + Objects.hashCode(this._transactionsPerSecond);
            result = 31 * result + Objects.hashCode(this._chainedTransactions);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!WriteTransactionsInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            WriteTransactionsInput other = (WriteTransactionsInput)obj;
            if (!Objects.equals(this._id, other.getId())) {
                return false;
            }
            if (!Objects.equals(this._seconds, other.getSeconds())) {
                return false;
            }
            if (!Objects.equals(this._transactionsPerSecond, other.getTransactionsPerSecond())) {
                return false;
            }
            if (!Objects.equals(this._chainedTransactions, other.isChainedTransactions())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                WriteTransactionsInputImpl otherImpl = (WriteTransactionsInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<WriteTransactionsInput>>, Augmentation<WriteTransactionsInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"WriteTransactionsInput");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_id", (Object)this._id);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_seconds", (Object)this._seconds);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_transactionsPerSecond", (Object)this._transactionsPerSecond);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_chainedTransactions", (Object)this._chainedTransactions);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

