/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.target.rev170215.id.ints.id._int;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.target.rev170215.id.ints.id._int.Item;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.target.rev170215.id.ints.id._int.ItemKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ItemBuilder
implements Builder<Item> {
    private Integer _number;
    private ItemKey key;
    Map<Class<? extends Augmentation<Item>>, Augmentation<Item>> augmentation = Collections.emptyMap();

    public ItemBuilder() {
    }

    public ItemBuilder(Item base) {
        Map aug;
        this.key = base.key();
        this._number = base.getNumber();
        if (base instanceof ItemImpl) {
            ItemImpl impl = (ItemImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Item>>, Augmentation<Item>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Item>>, Augmentation<Item>>(aug);
        }
    }

    public ItemKey key() {
        return this.key;
    }

    public Integer getNumber() {
        return this._number;
    }

    public <E$$ extends Augmentation<Item>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public ItemBuilder withKey(ItemKey key) {
        this.key = key;
        return this;
    }

    public ItemBuilder setNumber(Integer value) {
        this._number = value;
        return this;
    }

    public ItemBuilder addAugmentation(Class<? extends Augmentation<Item>> augmentationType, Augmentation<Item> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Item>>, Augmentation<Item>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ItemBuilder removeAugmentation(Class<? extends Augmentation<Item>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Item build() {
        return new ItemImpl(this);
    }

    private static final class ItemImpl
    implements Item {
        private final Integer _number;
        private final ItemKey key;
        private Map<Class<? extends Augmentation<Item>>, Augmentation<Item>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        ItemImpl(ItemBuilder base) {
            this.key = base.key() != null ? base.key() : new ItemKey(base.getNumber());
            this._number = this.key.getNumber();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Item> getImplementedInterface() {
            return Item.class;
        }

        @Override
        public ItemKey key() {
            return this.key;
        }

        @Override
        public Integer getNumber() {
            return this._number;
        }

        public <E$$ extends Augmentation<Item>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._number);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Item.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Item other = (Item)obj;
            if (!Objects.equals(this._number, other.getNumber())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ItemImpl otherImpl = (ItemImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Item>>, Augmentation<Item>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Item");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_number", (Object)this._number);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

