/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.common.errors;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.yangtools.yang.common.OperationFailedException;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class RestconfDocumentedException
extends WebApplicationException {
    private static final long serialVersionUID = 1L;
    private final ImmutableList<RestconfError> errors;
    private final Response.Status status;

    public RestconfDocumentedException(String message) {
        this(message, RestconfError.ErrorType.APPLICATION, RestconfError.ErrorTag.OPERATION_FAILED);
    }

    public RestconfDocumentedException(String message, RestconfError.ErrorType errorType, RestconfError.ErrorTag errorTag, Throwable cause) {
        this(cause, new RestconfError(errorType, errorTag, message, null, cause.getMessage(), null));
    }

    public RestconfDocumentedException(String message, RestconfError.ErrorType errorType, RestconfError.ErrorTag errorTag) {
        this(null, new RestconfError(errorType, errorTag, message));
    }

    public RestconfDocumentedException(String message, RestconfError.ErrorType errorType, RestconfError.ErrorTag errorTag, YangInstanceIdentifier errorPath) {
        this(null, new RestconfError(errorType, errorTag, message, errorPath));
    }

    public RestconfDocumentedException(String message, Throwable cause) {
        this(cause, new RestconfError(RestconfError.ErrorType.APPLICATION, RestconfError.ErrorTag.OPERATION_FAILED, message, null, cause.getMessage(), null));
    }

    public RestconfDocumentedException(RestconfError error) {
        this(null, error);
    }

    public RestconfDocumentedException(String message, Throwable cause, List<RestconfError> errors) {
        super(cause);
        this.errors = !errors.isEmpty() ? ImmutableList.copyOf(errors) : ImmutableList.of((Object)new RestconfError(RestconfError.ErrorType.APPLICATION, RestconfError.ErrorTag.OPERATION_FAILED, message));
        this.status = null;
    }

    public RestconfDocumentedException(String message, Throwable cause, Collection<? extends RpcError> rpcErrors) {
        this(message, cause, RestconfDocumentedException.convertToRestconfErrors(rpcErrors));
    }

    public RestconfDocumentedException(Response.Status status) {
        Preconditions.checkNotNull((Object)status, (Object)"Status can't be null");
        this.errors = ImmutableList.of();
        this.status = status;
    }

    public RestconfDocumentedException(Throwable cause, RestconfError error) {
        super(cause, error.getErrorTag().getStatusCode());
        Preconditions.checkNotNull((Object)error, (Object)"RestconfError can't be null");
        this.errors = ImmutableList.of((Object)error);
        this.status = null;
    }

    public static RestconfDocumentedException decodeAndThrow(String message, OperationFailedException cause) {
        for (RpcError error : cause.getErrorList()) {
            if (error.getErrorType() != RpcError.ErrorType.TRANSPORT || !error.getTag().equals(RestconfError.ErrorTag.RESOURCE_DENIED.getTagValue())) continue;
            throw new RestconfDocumentedException(error.getMessage(), RestconfError.ErrorType.TRANSPORT, RestconfError.ErrorTag.RESOURCE_DENIED_TRANSPORT, (Throwable)cause);
        }
        throw new RestconfDocumentedException(message, (Throwable)cause, cause.getErrorList());
    }

    private static List<RestconfError> convertToRestconfErrors(Collection<? extends RpcError> rpcErrors) {
        ArrayList<RestconfError> errorList = new ArrayList<RestconfError>();
        if (rpcErrors != null) {
            for (RpcError rpcError : rpcErrors) {
                errorList.add(new RestconfError(rpcError));
            }
        }
        return errorList;
    }

    public List<RestconfError> getErrors() {
        return this.errors;
    }

    public Response.Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return "errors: " + this.errors + (this.status != null ? ", status: " + this.status : "");
    }
}

