/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.common.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;

public class MultivaluedHashMap<K, V>
implements MultivaluedMap<K, V> {
    private final Map<K, List<V>> store = new HashMap<K, List<V>>();

    public final void putSingle(K key, V value) {
        List<V> values = this.getValues(key);
        values.clear();
        if (value != null) {
            values.add(value);
        }
    }

    public void add(K key, V value) {
        List<V> values = this.getValues(key);
        if (value != null) {
            values.add(value);
        }
    }

    @SafeVarargs
    public final void addAll(K key, V ... newValues) {
        this.addAll(key, Arrays.asList(newValues));
    }

    public void addAll(K key, List<V> valueList) {
        Objects.requireNonNull(valueList, "Supplied list of values must not be null.");
        if (valueList.isEmpty()) {
            return;
        }
        List<V> values = this.getValues(key);
        for (V value : valueList) {
            if (value == null) continue;
            values.add(value);
        }
    }

    public void addFirst(K key, V value) {
        List<V> values = this.getValues(key);
        if (value != null) {
            values.add(0, value);
        }
    }

    public V getFirst(K key) {
        List<V> values = this.store.get(key);
        return values == null || values.isEmpty() ? null : (V)values.get(0);
    }

    public boolean equalsIgnoreValueOrder(MultivaluedMap<K, V> omap) {
        if (this == omap) {
            return true;
        }
        if (!this.keySet().equals(omap.keySet())) {
            return false;
        }
        for (Map.Entry<K, List<V>> e : this.entrySet()) {
            List olist = (List)omap.get(e.getKey());
            if (e.getValue().size() != olist.size()) {
                return false;
            }
            for (V v : e.getValue()) {
                if (olist.contains(v)) continue;
                return false;
            }
        }
        return true;
    }

    public Collection<List<V>> values() {
        return this.store.values();
    }

    public int size() {
        return this.store.size();
    }

    public List<V> remove(Object key) {
        return this.store.remove(key);
    }

    public void putAll(Map<? extends K, ? extends List<V>> map) {
        this.store.putAll(map);
    }

    public List<V> put(K key, List<V> value) {
        return this.store.put(key, value);
    }

    public Set<K> keySet() {
        return this.store.keySet();
    }

    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    public List<V> get(Object key) {
        return this.store.get(key);
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.store.entrySet();
    }

    public boolean containsValue(Object value) {
        return this.store.containsValue(value);
    }

    public boolean containsKey(Object key) {
        return this.store.containsKey(key);
    }

    public void clear() {
        this.store.clear();
    }

    private List<V> getValues(K key) {
        return this.store.computeIfAbsent(key, k -> new LinkedList());
    }
}

