/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.common.validation;

import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;

public final class RestconfValidationUtils {
    private RestconfValidationUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void checkDocumentedError(boolean condition, RestconfError.ErrorType type, RestconfError.ErrorTag tag, String message) {
        if (!condition) {
            throw new RestconfDocumentedException(message, type, tag);
        }
    }

    public static <T> T checkNotNullDocumented(T value, String moduleName) {
        if (value == null) {
            String errMsg = "Module " + moduleName + " was not found.";
            throw new RestconfDocumentedException(errMsg, RestconfError.ErrorType.APPLICATION, RestconfError.ErrorTag.DATA_MISSING);
        }
        return value;
    }
}

