/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.util;

import com.google.common.annotations.Beta;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;

@Beta
public abstract class Datastore {
    public static final Class<Configuration> CONFIGURATION = Configuration.class;
    public static final Class<Operational> OPERATIONAL = Operational.class;

    public static LogicalDatastoreType toType(Class<? extends Datastore> datastoreClass) {
        if (datastoreClass.equals(Configuration.class)) {
            return LogicalDatastoreType.CONFIGURATION;
        }
        if (Operational.class.equals(datastoreClass)) {
            return LogicalDatastoreType.OPERATIONAL;
        }
        throw new IllegalArgumentException("Unknown datastore class " + datastoreClass);
    }

    public static Class<? extends Datastore> toClass(LogicalDatastoreType datastoreType) {
        switch (datastoreType) {
            case CONFIGURATION: {
                return CONFIGURATION;
            }
            case OPERATIONAL: {
                return OPERATIONAL;
            }
        }
        throw new IllegalArgumentException("Unknown datastore type " + datastoreType);
    }

    private Datastore() {
    }

    public static final class Operational
    extends Datastore {
    }

    public static final class Configuration
    extends Datastore {
    }
}

