/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.util;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.opendaylight.mdsal.binding.util.CheckedConsumer;
import org.opendaylight.mdsal.binding.util.CheckedFunction;
import org.opendaylight.mdsal.binding.util.Datastore;
import org.opendaylight.mdsal.binding.util.InterruptibleCheckedConsumer;
import org.opendaylight.mdsal.binding.util.InterruptibleCheckedFunction;
import org.opendaylight.mdsal.binding.util.ManagedNewTransactionRunner;
import org.opendaylight.mdsal.binding.util.ManagedTransactionChain;
import org.opendaylight.mdsal.binding.util.TypedReadTransaction;
import org.opendaylight.mdsal.binding.util.TypedReadWriteTransaction;
import org.opendaylight.mdsal.binding.util.TypedWriteTransaction;
import org.opendaylight.mdsal.common.api.OptimisticLockFailedException;
import org.opendaylight.mdsal.common.api.ReadFailedException;

class RetryingManagedNewTransactionRunnerImpl
implements ManagedNewTransactionRunner {
    private static final int DEFAULT_RETRIES = 3;
    private final int maxRetries;
    private final ManagedNewTransactionRunner delegate;
    private final Executor executor;

    RetryingManagedNewTransactionRunnerImpl(ManagedNewTransactionRunner delegate) {
        this(delegate, MoreExecutors.directExecutor(), 3);
    }

    RetryingManagedNewTransactionRunnerImpl(ManagedNewTransactionRunner delegate, int maxRetries) {
        this(delegate, MoreExecutors.directExecutor(), maxRetries);
    }

    RetryingManagedNewTransactionRunnerImpl(ManagedNewTransactionRunner delegate, Executor executor, int maxRetries) {
        this.delegate = Objects.requireNonNull(delegate, "delegate must not be null");
        this.executor = Objects.requireNonNull(executor, "executor must not be null");
        this.maxRetries = maxRetries;
    }

    @Override
    public <D extends Datastore, E extends Exception, R> R applyInterruptiblyWithNewReadOnlyTransactionAndClose(Class<D> datastoreType, InterruptibleCheckedFunction<TypedReadTransaction<D>, R, E> txFunction) throws E, InterruptedException {
        return this.applyInterruptiblyWithNewReadOnlyTransactionAndClose(datastoreType, txFunction, this.maxRetries);
    }

    private <R, D extends Datastore, E extends Exception> R applyInterruptiblyWithNewReadOnlyTransactionAndClose(Class<D> datastoreType, InterruptibleCheckedFunction<TypedReadTransaction<D>, R, E> txFunction, int tries) throws E, InterruptedException {
        try {
            return this.delegate.applyInterruptiblyWithNewReadOnlyTransactionAndClose(datastoreType, txFunction);
        }
        catch (Exception e) {
            if (this.isRetriableException(e) && tries - 1 > 0) {
                return this.applyInterruptiblyWithNewReadOnlyTransactionAndClose(datastoreType, txFunction, tries - 1);
            }
            throw e;
        }
    }

    @Override
    public <D extends Datastore, E extends Exception, R> R applyWithNewReadOnlyTransactionAndClose(Class<D> datastoreType, CheckedFunction<TypedReadTransaction<D>, R, E> txFunction) throws E {
        return this.applyWithNewReadOnlyTransactionAndClose(datastoreType, txFunction, this.maxRetries);
    }

    private <R, D extends Datastore, E extends Exception> R applyWithNewReadOnlyTransactionAndClose(Class<D> datastoreType, CheckedFunction<TypedReadTransaction<D>, R, E> txFunction, int tries) throws E {
        try {
            return this.delegate.applyWithNewReadOnlyTransactionAndClose(datastoreType, txFunction);
        }
        catch (Exception e) {
            if (this.isRetriableException(e) && tries - 1 > 0) {
                return this.applyWithNewReadOnlyTransactionAndClose(datastoreType, txFunction, tries - 1);
            }
            throw e;
        }
    }

    @Override
    public <D extends Datastore, E extends Exception, R> FluentFuture<R> applyWithNewReadWriteTransactionAndSubmit(Class<D> datastoreType, InterruptibleCheckedFunction<TypedReadWriteTransaction<D>, R, E> txFunction) {
        return this.applyWithNewReadWriteTransactionAndSubmit(datastoreType, txFunction, this.maxRetries);
    }

    private <D extends Datastore, E extends Exception, R> FluentFuture<R> applyWithNewReadWriteTransactionAndSubmit(Class<D> datastoreType, InterruptibleCheckedFunction<TypedReadWriteTransaction<D>, R, E> txRunner, int tries) {
        FluentFuture<R> future = Objects.requireNonNull(this.delegate.applyWithNewReadWriteTransactionAndSubmit(datastoreType, txRunner), "delegate.callWithNewReadWriteTransactionAndSubmit() == null");
        return future.catchingAsync(Exception.class, exception -> {
            if (this.isRetriableException((Throwable)exception) && tries - 1 > 0) {
                return this.applyWithNewReadWriteTransactionAndSubmit(datastoreType, txRunner, tries - 1);
            }
            throw exception;
        }, this.executor);
    }

    @Override
    public <R> R applyWithNewTransactionChainAndClose(Function<ManagedTransactionChain, R> chainConsumer) {
        throw new UnsupportedOperationException("The retrying transaction manager doesn't support transaction chains");
    }

    @Override
    public <D extends Datastore, E extends Exception> void callInterruptiblyWithNewReadOnlyTransactionAndClose(Class<D> datastoreType, InterruptibleCheckedConsumer<TypedReadTransaction<D>, E> txConsumer) throws E, InterruptedException {
        this.callInterruptiblyWithNewReadOnlyTransactionAndClose(datastoreType, txConsumer, this.maxRetries);
    }

    private <D extends Datastore, E extends Exception> void callInterruptiblyWithNewReadOnlyTransactionAndClose(Class<D> datastoreType, InterruptibleCheckedConsumer<TypedReadTransaction<D>, E> txConsumer, int tries) throws E, InterruptedException {
        try {
            this.delegate.callInterruptiblyWithNewReadOnlyTransactionAndClose(datastoreType, txConsumer);
        }
        catch (Exception e) {
            if (this.isRetriableException(e) && tries - 1 > 0) {
                this.callInterruptiblyWithNewReadOnlyTransactionAndClose(datastoreType, txConsumer, tries - 1);
            }
            throw e;
        }
    }

    @Override
    public <D extends Datastore, E extends Exception> void callWithNewReadOnlyTransactionAndClose(Class<D> datastoreType, CheckedConsumer<TypedReadTransaction<D>, E> txConsumer) throws E {
        this.callWithNewReadOnlyTransactionAndClose(datastoreType, txConsumer, this.maxRetries);
    }

    private <D extends Datastore, E extends Exception> void callWithNewReadOnlyTransactionAndClose(Class<D> datastoreType, CheckedConsumer<TypedReadTransaction<D>, E> txConsumer, int tries) throws E {
        try {
            this.delegate.callWithNewReadOnlyTransactionAndClose(datastoreType, txConsumer);
        }
        catch (Exception e) {
            if (this.isRetriableException(e) && tries - 1 > 0) {
                this.callWithNewReadOnlyTransactionAndClose(datastoreType, txConsumer, tries - 1);
            }
            throw e;
        }
    }

    @Override
    public <D extends Datastore, E extends Exception> FluentFuture<? extends Object> callWithNewReadWriteTransactionAndSubmit(Class<D> datastoreType, InterruptibleCheckedConsumer<TypedReadWriteTransaction<D>, E> txConsumer) {
        return this.callWithNewReadWriteTransactionAndSubmit(datastoreType, txConsumer, this.maxRetries);
    }

    private <D extends Datastore, E extends Exception, T> FluentFuture<T> callWithNewReadWriteTransactionAndSubmit(Class<D> datastoreType, InterruptibleCheckedConsumer<TypedReadWriteTransaction<D>, E> txRunner, int tries) {
        return Objects.requireNonNull(this.delegate.callWithNewReadWriteTransactionAndSubmit(datastoreType, txRunner), "delegate.callWithNewWriteOnlyTransactionAndSubmit() == null").catchingAsync(Exception.class, exception -> {
            if (this.isRetriableException((Throwable)exception) && tries - 1 > 0) {
                return this.callWithNewReadWriteTransactionAndSubmit(datastoreType, txRunner, tries - 1);
            }
            throw exception;
        }, this.executor);
    }

    @Override
    public <D extends Datastore, E extends Exception> FluentFuture<? extends Object> callWithNewWriteOnlyTransactionAndSubmit(Class<D> datastoreType, InterruptibleCheckedConsumer<TypedWriteTransaction<D>, E> txConsumer) {
        return this.callWithNewWriteOnlyTransactionAndSubmit(datastoreType, txConsumer, this.maxRetries);
    }

    private <D extends Datastore, E extends Exception, T> FluentFuture<T> callWithNewWriteOnlyTransactionAndSubmit(Class<D> datastoreType, InterruptibleCheckedConsumer<TypedWriteTransaction<D>, E> txRunner, int tries) {
        return Objects.requireNonNull(this.delegate.callWithNewWriteOnlyTransactionAndSubmit(datastoreType, txRunner), "delegate.callWithNewWriteOnlyTransactionAndSubmit() == null").catchingAsync(OptimisticLockFailedException.class, optimisticLockFailedException -> {
            if (tries - 1 > 0) {
                return this.callWithNewWriteOnlyTransactionAndSubmit(datastoreType, txRunner, tries - 1);
            }
            throw optimisticLockFailedException;
        }, this.executor);
    }

    private boolean isRetriableException(Throwable throwable) {
        return throwable instanceof OptimisticLockFailedException || throwable instanceof ReadFailedException || throwable instanceof ExecutionException && this.isRetriableException(throwable.getCause());
    }
}

