/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationListener;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationPublishService;
import org.opendaylight.controller.md.sal.dom.spi.DOMNotificationSubscriptionListener;
import org.opendaylight.controller.md.sal.dom.spi.DOMNotificationSubscriptionListenerRegistry;
import org.opendaylight.controller.sal.core.compat.LegacyDOMNotificationServiceAdapter;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

@SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"}, justification="Void is the only allowed value")
public final class DOMNotificationRouter
extends LegacyDOMNotificationServiceAdapter
implements AutoCloseable,
DOMNotificationPublishService,
DOMNotificationSubscriptionListenerRegistry {
    private final org.opendaylight.mdsal.dom.api.DOMNotificationPublishService delegateNotificationPublishService;
    private final org.opendaylight.mdsal.dom.spi.DOMNotificationSubscriptionListenerRegistry delegateListenerRegistry;

    private DOMNotificationRouter(DOMNotificationService delegateNotificationService, org.opendaylight.mdsal.dom.api.DOMNotificationPublishService delegateNotificationPublishService, org.opendaylight.mdsal.dom.spi.DOMNotificationSubscriptionListenerRegistry delegateListenerRegistry) {
        super(delegateNotificationService);
        this.delegateNotificationPublishService = delegateNotificationPublishService;
        this.delegateListenerRegistry = delegateListenerRegistry;
    }

    public static DOMNotificationRouter create(int queueDepth) {
        org.opendaylight.mdsal.dom.broker.DOMNotificationRouter delegate = org.opendaylight.mdsal.dom.broker.DOMNotificationRouter.create((int)queueDepth);
        return DOMNotificationRouter.create((DOMNotificationService)delegate, (org.opendaylight.mdsal.dom.api.DOMNotificationPublishService)delegate, (org.opendaylight.mdsal.dom.spi.DOMNotificationSubscriptionListenerRegistry)delegate);
    }

    public static DOMNotificationRouter create(int queueDepth, long spinTime, long parkTime, TimeUnit unit) {
        org.opendaylight.mdsal.dom.broker.DOMNotificationRouter delegate = org.opendaylight.mdsal.dom.broker.DOMNotificationRouter.create((int)queueDepth, (long)spinTime, (long)parkTime, (TimeUnit)unit);
        return DOMNotificationRouter.create((DOMNotificationService)delegate, (org.opendaylight.mdsal.dom.api.DOMNotificationPublishService)delegate, (org.opendaylight.mdsal.dom.spi.DOMNotificationSubscriptionListenerRegistry)delegate);
    }

    public static DOMNotificationRouter create(DOMNotificationService delegateNotificationService, org.opendaylight.mdsal.dom.api.DOMNotificationPublishService delegateNotificationPublishService, org.opendaylight.mdsal.dom.spi.DOMNotificationSubscriptionListenerRegistry delegateListenerRegistry) {
        return new DOMNotificationRouter(delegateNotificationService, delegateNotificationPublishService, delegateListenerRegistry);
    }

    public synchronized <T extends DOMNotificationListener> ListenerRegistration<T> registerNotificationListener(T listener, Collection<SchemaPath> types) {
        return super.registerNotificationListener(listener, types);
    }

    public <L extends DOMNotificationSubscriptionListener> ListenerRegistration<L> registerSubscriptionListener(L listener) {
        return this.delegateListenerRegistry.registerSubscriptionListener(listener);
    }

    public ListenableFuture<?> putNotification(org.opendaylight.controller.md.sal.dom.api.DOMNotification notification) throws InterruptedException {
        return this.delegateNotificationPublishService.putNotification((DOMNotification)notification);
    }

    public ListenableFuture<?> offerNotification(org.opendaylight.controller.md.sal.dom.api.DOMNotification notification) {
        return this.delegateNotificationPublishService.offerNotification((DOMNotification)notification);
    }

    public ListenableFuture<?> offerNotification(org.opendaylight.controller.md.sal.dom.api.DOMNotification notification, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegateNotificationPublishService.offerNotification((DOMNotification)notification, timeout, unit);
    }

    @Override
    public void close() {
    }
}

